/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.CellContextInfo;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnBandAction;
import org.eclipse.birt.report.model.api.ColumnBandAdapter;
import org.eclipse.birt.report.model.api.ColumnBandData;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableColumnBandAdapter;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.elements.ColumnHelper;
import org.eclipse.birt.report.model.elements.TableColumn;
import org.eclipse.birt.report.model.util.CommandLabelFactory;

class ColumnBandShiftAction
extends ColumnBandAction {
    private boolean weakMode;

    public ColumnBandShiftAction(ColumnBandAdapter adapter) {
        super(adapter);
    }

    public ColumnBandShiftAction(ColumnBandAdapter adapter, boolean weakMode) {
        this(adapter);
        this.weakMode = weakMode;
    }

    protected ColumnBandData getShiftData(int sourceIndex) throws SemanticException {
        ColumnBandData data;
        block7: {
            if (sourceIndex <= 0) {
                throw new IllegalArgumentException("wrong column to shift");
            }
            data = new ColumnBandData();
            TableColumn column = ColumnHelper.findColumn(this.adapter.getModule(), this.adapter.getColumns().getSlot(), sourceIndex);
            if (column != null) {
                try {
                    column = (TableColumn)column.clone();
                    column.setProperty("repeat", (Object)1);
                    data.setColumn(column);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError();
                }
            }
        }
        List cells = this.getCellsContextInfo(this.adapter.getCellsUnderColumn(sourceIndex));
        if (this.weakMode) {
            cells = this.filter(cells, true);
        }
        data.setCells(cells);
        if (!this.weakMode && !this.isRectangleArea(cells, 1)) {
            throw new SemanticError(this.adapter.getElementHandle().getElement(), new String[]{Integer.toString(sourceIndex), this.adapter.getElementHandle().getName()}, "Error.SemanticError.COLUMN_COPY_FORBIDDEN");
        }
        if (!this.weakMode && this.adapter.hasDroppingCell(cells)) {
            throw new SemanticError(this.adapter.getElementHandle().getElement(), new String[]{Integer.toString(sourceIndex), this.adapter.getElementHandle().getName()}, "Error.SemanticError.COLUMN_COPY_FORBIDDEN");
        }
        return data;
    }

    private List filter(List cellContextInfos, boolean valid) {
        ArrayList<CellContextInfo> retval = new ArrayList<CellContextInfo>();
        for (Object obj : cellContextInfos) {
            CellContextInfo cellInfo = (CellContextInfo)obj;
            if (valid ^ this.isValid(cellInfo)) continue;
            retval.add(cellInfo);
        }
        return retval;
    }

    private boolean isValid(CellContextInfo cellInfo) {
        return cellInfo.getColumnSpan() == 1 || this.adapter.isDroppingCell(cellInfo);
    }

    private int adjustDestPosn(int posn, int newPosn) {
        int columnCount = this.adapter.getColumnCount();
        if (newPosn > columnCount) {
            return columnCount;
        }
        if (posn == newPosn) {
            return -1;
        }
        return newPosn;
    }

    protected void shiftColumnBand(int sourceColumn, int destColumn) throws SemanticException {
        ColumnBandData data = this.getShiftData(sourceColumn);
        int newPosn = this.adjustDestPosn(sourceColumn, destColumn);
        if (newPosn == -1) {
            return;
        }
        if (this.weakMode) {
            List invalidCells = this.filter(this.getCellsContextInfo(this.adapter.getCellsUnderColumn(destColumn)), false);
            for (Object obj : invalidCells) {
                CellContextInfo invalidCell = (CellContextInfo)obj;
                Iterator iter = data.getCells().iterator();
                while (iter.hasNext()) {
                    CellContextInfo cell = (CellContextInfo)iter.next();
                    if (cell.getSlotId() != invalidCell.getSlotId() || cell.getRowIndex() != invalidCell.getRowIndex() || cell.getGroupId() != invalidCell.getGroupId()) continue;
                    iter.remove();
                }
            }
        }
        if (!this.weakMode && !this.checkTargetColumn(sourceColumn, destColumn)) {
            throw new SemanticError(this.adapter.getElementHandle().getElement(), new String[]{Integer.toString(sourceColumn), this.adapter.getElementHandle().getName()}, "Error.SemanticError.COLUMN_PASTE_FORBIDDEN");
        }
        ActivityStack as = this.adapter.getModule().getActivityStack();
        try {
            if (this.adapter instanceof TableColumnBandAdapter) {
                as.startSilentTrans(CommandLabelFactory.getCommandLabel("Message.ShiftColumnBand"));
            } else {
                as.startTrans(CommandLabelFactory.getCommandLabel("Message.ShiftColumnBand"));
            }
            this.shiftColumn(data.getColumn(), sourceColumn, newPosn);
            this.shiftCells(data.getCells(), sourceColumn, newPosn);
        }
        catch (SemanticException e) {
            as.rollback();
            throw e;
        }
        as.commit();
    }

    private void shiftColumn(TableColumn column, int sourceIndex, int destIndex) throws SemanticException {
        if (column == null) {
            return;
        }
        SlotHandle columns = this.adapter.getColumns();
        TableColumn sourceColumn = ColumnHelper.findColumn(this.adapter.getModule(), columns.getSlot(), sourceIndex);
        ColumnHandle sourceCol = (ColumnHandle)sourceColumn.getHandle(this.adapter.getModule());
        this.pasteColumn(column, destIndex, true);
        int repeat = sourceCol.getRepeatCount();
        if (repeat == 1) {
            columns.drop(sourceCol);
        } else {
            sourceCol.setRepeatCount(repeat - 1);
        }
    }

    private void shiftCells(List cellInfos, int sourceIndex, int destIndex) throws SemanticException {
        List destCells = this.adapter.getCellsUnderColumn(destIndex);
        List destContexts = this.getCellsContextInfo(destCells);
        int i = 0;
        while (i < cellInfos.size()) {
            block8: {
                int newPosn;
                int oldPosn;
                CellHandle cell;
                RowHandle row;
                block7: {
                    CellContextInfo contextInfo;
                    block6: {
                        contextInfo = (CellContextInfo)cellInfos.get(i);
                        row = this.adapter.getRow(contextInfo.getSlotId(), contextInfo.getGroupId(), contextInfo.getRowIndex());
                        assert (row != null);
                        cell = contextInfo.getCell().handle(this.adapter.getModule());
                        cell.setColumn(0);
                        oldPosn = row.getCells().findPosn(cell);
                        newPosn = 0;
                        if (destIndex != 0) break block6;
                        newPosn = 0;
                        break block7;
                    }
                    CellContextInfo destContext = this.findCorrespondingCell(destContexts, contextInfo);
                    if (destContext == null) break block8;
                    CellHandle destCell = destContext.getCell().handle(this.adapter.getModule());
                    newPosn = row.getCells().findPosn(destCell);
                    if (oldPosn > newPosn + 1) {
                        ++newPosn;
                    }
                }
                row.getCells().shift(cell, newPosn);
                this.clearsCellColumnProperties(row, oldPosn, newPosn);
            }
            ++i;
        }
    }

    private CellContextInfo findCorrespondingCell(List destContexts, CellContextInfo srcCell) {
        for (Object obj : destContexts) {
            CellContextInfo cell = (CellContextInfo)obj;
            if (cell.getSlotId() != srcCell.getSlotId() || cell.getRowIndex() != srcCell.getRowIndex() || cell.getGroupId() != srcCell.getGroupId()) continue;
            return cell;
        }
        return null;
    }

    protected void clearsCellColumnProperties(RowHandle row, int fromPosn, int toPosn) throws SemanticException {
        int fromIndex = fromPosn;
        int endIndex = toPosn;
        if (fromPosn > toPosn) {
            fromIndex = toPosn;
            endIndex = fromPosn;
        }
        if (row.getCells().getCount() <= endIndex) {
            endIndex = row.getCells().getCount() - 1;
        }
        int i = fromIndex;
        while (i <= endIndex) {
            CellHandle cell = (CellHandle)row.getCells().get(i);
            cell.setColumn(0);
            ++i;
        }
    }

    protected boolean checkTargetColumn(int sourceColumn, int destColumn) {
        if (this.adapter.hasParent()) {
            return false;
        }
        int newPosn = this.adjustDestPosn(sourceColumn, destColumn);
        if (newPosn == -1) {
            return true;
        }
        int columnCount = this.adapter.getColumnCount();
        if (newPosn == 0 || newPosn == columnCount) {
            return true;
        }
        List originalCells = this.getCellsContextInfo(this.adapter.getCellsUnderColumn(newPosn));
        return this.isRectangleArea(originalCells, 1);
    }
}

