/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.palette.command.factory;

import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.editor.palette.model.PaletteInfo;
import org.eclipse.wb.internal.core.editor.palette.command.factory.FactoryAbstractCommand;
import org.eclipse.wb.internal.core.editor.palette.model.entry.FactoryEntryInfo;
import org.eclipse.wb.internal.core.editor.palette.model.entry.InstanceFactoryEntryInfo;
import org.eclipse.wb.internal.core.editor.palette.model.entry.StaticFactoryEntryInfo;
import org.xml.sax.Attributes;

public final class FactoryAddCommand
extends FactoryAbstractCommand {
    public static final String ID = "addFactory";
    private final String m_categoryId;

    public FactoryAddCommand(String id, String name, String description, boolean visible, String factoryClassName, String methodSignature, boolean forStatic, CategoryInfo category) {
        super(id, name, description, visible, factoryClassName, methodSignature, forStatic);
        this.m_categoryId = category.getId();
    }

    public FactoryAddCommand(Attributes attributes) {
        super(attributes);
        this.m_categoryId = attributes.getValue("category");
    }

    @Override
    public void execute(PaletteInfo palette) {
        FactoryEntryInfo entry = this.m_forStatic ? new StaticFactoryEntryInfo() : new InstanceFactoryEntryInfo();
        entry.setId(this.m_id);
        this.updateElement(entry);
        CategoryInfo category = palette.getCategory(this.m_categoryId);
        category.addEntry(entry);
    }

    @Override
    protected void addAttributes() {
        super.addAttributes();
        this.addAttribute("category", this.m_categoryId);
    }
}

