/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.internal.core.model;

import java.io.File;
import java.io.UnsupportedEncodingException;
import org.eclipse.dstore.core.model.IByteConverter;

public class DefaultByteConverter
implements IByteConverter {
    private String _clientEncoding = "UTF-8";
    private String _hostEncoding = System.getProperty("file.encoding");

    public void setContext(File file) {
    }

    public void setHostEncoding(String hostEncoding) {
        this._hostEncoding = hostEncoding;
    }

    public void setClientEncoding(String clientEncoding) {
        this._clientEncoding = clientEncoding;
    }

    public byte[] convertHostBytesToClientBytes(byte[] buffer, int offset, int length) {
        byte[] convertedBytes = null;
        try {
            convertedBytes = new String(buffer, offset, length, this._hostEncoding).getBytes(this._clientEncoding);
        }
        catch (UnsupportedEncodingException e) {
            try {
                convertedBytes = new String(buffer, offset, length).getBytes(this._clientEncoding);
            }
            catch (UnsupportedEncodingException e2) {
                return buffer;
            }
        }
        return convertedBytes;
    }

    public byte[] convertClientBytesToHostBytes(byte[] buffer, int offset, int length) {
        byte[] convertedBytes = null;
        try {
            convertedBytes = new String(buffer, offset, length, this._clientEncoding).getBytes(this._hostEncoding);
        }
        catch (UnsupportedEncodingException e) {
            try {
                convertedBytes = new String(buffer, offset, length).getBytes(this._hostEncoding);
            }
            catch (UnsupportedEncodingException e2) {
                return buffer;
            }
        }
        return convertedBytes;
    }
}

