/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class PathTools {
    public static IContainer getContainer(IPath fullContainerPath) {
        String projectName = fullContainerPath.segment(0).toString();
        IPath projectRelativePath = fullContainerPath.removeFirstSegments(1);
        IProject project = PathTools.getWorkspaceRoot().getProject(projectName);
        return projectRelativePath.isEmpty() ? project : project.getFolder(projectRelativePath);
    }

    public static IFile getFile(IPath fullFilePath) {
        String projectName = fullFilePath.segment(0).toString();
        IPath projectRelativePath = fullFilePath.removeFirstSegments(1);
        IProject project = PathTools.getWorkspaceRoot().getProject(projectName);
        return project.getFile(projectRelativePath);
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return PathTools.getWorkspace().getRoot();
    }

    static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    private PathTools() {
        throw new UnsupportedOperationException();
    }
}

