/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.caching;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.dltk.compiler.util.Util;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.caching.IContentCache;
import org.eclipse.dltk.core.environment.IFileHandle;

public abstract class AbstractContentCache
implements IContentCache {
    @Override
    public synchronized String getCacheEntryAttributeString(IFileHandle handle, String attribute) {
        return this.getCacheEntryAttributeString(handle, attribute, false);
    }

    @Override
    public synchronized String getCacheEntryAttributeString(IFileHandle handle, String attribute, boolean localonly) {
        InputStream stream = this.getCacheEntryAttribute(handle, attribute, localonly);
        if (stream != null) {
            try {
                char[] chars = Util.getInputStreamAsCharArray(stream, -1, null);
                String string = new String(chars);
                return string;
            }
            catch (IOException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            finally {
                block14: {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        if (!DLTKCore.DEBUG) break block14;
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    @Override
    public boolean setCacheEntryAttribute(IFileHandle handle, String attribute, String value) {
        OutputStream outputStream = this.getCacheEntryAttributeOutputStream(handle, attribute);
        if (outputStream != null) {
            try {
                try {
                    outputStream.write(value.getBytes());
                }
                catch (IOException e) {
                    block14: {
                        if (DLTKCore.DEBUG) {
                            e.printStackTrace();
                        }
                        try {
                            outputStream.close();
                        }
                        catch (IOException e2) {
                            if (!DLTKCore.DEBUG) break block14;
                            e2.printStackTrace();
                        }
                    }
                    return false;
                }
            }
            finally {
                block15: {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        if (!DLTKCore.DEBUG) break block15;
                        e.printStackTrace();
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized long getCacheEntryAttributeLong(IFileHandle handle, String attribute) {
        return this.getCacheEntryAttributeLong(handle, attribute, false);
    }

    @Override
    public synchronized long getCacheEntryAttributeLong(IFileHandle handle, String attribute, boolean localonly) {
        InputStream stream = this.getCacheEntryAttribute(handle, attribute, localonly);
        if (stream != null) {
            try {
                long result;
                DataInputStream dias = new DataInputStream(stream);
                long l = result = dias.readLong();
                return l;
            }
            catch (IOException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            finally {
                block14: {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        if (!DLTKCore.DEBUG) break block14;
                        e.printStackTrace();
                    }
                }
            }
        }
        return 0L;
    }

    @Override
    public boolean setCacheEntryAttribute(IFileHandle handle, String attribute, long value) {
        OutputStream outputStream = this.getCacheEntryAttributeOutputStream(handle, attribute);
        if (outputStream != null) {
            try {
                try {
                    DataOutputStream dout = new DataOutputStream(outputStream);
                    dout.writeLong(value);
                    dout.close();
                }
                catch (IOException e) {
                    block14: {
                        if (DLTKCore.DEBUG) {
                            e.printStackTrace();
                        }
                        try {
                            outputStream.close();
                        }
                        catch (IOException e2) {
                            if (!DLTKCore.DEBUG) break block14;
                            e2.printStackTrace();
                        }
                    }
                    return false;
                }
            }
            finally {
                block15: {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        if (!DLTKCore.DEBUG) break block15;
                        e.printStackTrace();
                    }
                }
            }
            return true;
        }
        return false;
    }
}

