/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.profile.provider;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.services.IPropertyProvider;
import org.eclipse.datatools.connectivity.oda.consumer.services.impl.ProviderUtil;
import org.eclipse.datatools.connectivity.oda.profile.OdaProfileExplorer;
import org.eclipse.datatools.connectivity.oda.profile.nls.Messages;
import org.eclipse.datatools.connectivity.oda.util.ResourceIdentifiers;
import org.eclipse.datatools.connectivity.services.PluginResourceLocator;

public class ProfilePropertyProviderImpl
implements IPropertyProvider {
    private static final String FILE_EXT_SEPARATOR = ".";
    private static final String PROFILE_STORE_FILE_ORIGINAL_EXT = "org.eclipse.datatools.connectivity.oda.profile_provider.storeFileOrigExt";
    private static final String sm_className = ProfilePropertyProviderImpl.class.getName();
    private static Logger sm_logger;
    private boolean m_refreshProfileStore = true;
    private String m_profileStoreFileExt = null;

    public Properties getDataSourceProperties(Properties candidateProperties, Object appContext) throws OdaException {
        String profileStoreResolvedPath;
        IConnectionProfile connProfile = null;
        OdaException causeEx = null;
        try {
            connProfile = this.getConnectionProfileImpl(candidateProperties, appContext);
        }
        catch (OdaException ex) {
            causeEx = ex;
        }
        if (connProfile == null) {
            if (this.hasProfileName(candidateProperties) && this.hasProfileStoreFilePath(candidateProperties)) {
                OdaException throwEx = new OdaException(Messages.bind((String)Messages.propertyProvider_CANNOT_FIND_PROFILE, (Object)this.getProfileName(candidateProperties), (Object)this.getProfileStoreFilePath(candidateProperties)));
                if (causeEx != null) {
                    throwEx.initCause((Throwable)causeEx);
                }
                throw throwEx;
            }
            return candidateProperties;
        }
        Properties mergedProps = new Properties();
        mergedProps.putAll((Map<?, ?>)candidateProperties);
        Properties profileProps = connProfile.getBaseProperties();
        if (profileProps != null) {
            mergedProps.putAll((Map<?, ?>)profileProps);
        }
        this.m_profileStoreFileExt = null;
        File profileStore = this.getProfileStoreFile(candidateProperties, appContext);
        if (profileStore != null && profileStore.exists() && !(profileStoreResolvedPath = profileStore.getPath()).equals(this.getProfileStoreFilePath(candidateProperties))) {
            mergedProps.setProperty("org.eclipse.datatools.connectivity.oda_transient.profileStorePath", profileStoreResolvedPath);
            if (this.m_profileStoreFileExt != null) {
                mergedProps.setProperty(PROFILE_STORE_FILE_ORIGINAL_EXT, this.m_profileStoreFileExt);
            }
        }
        if (ProfilePropertyProviderImpl.getLogger().isLoggable(Level.FINER)) {
            String logMsg = String.valueOf(sm_className) + FILE_EXT_SEPARATOR + "getDataSourceProperties(Properties,Object)" + ": ";
            logMsg = String.valueOf(logMsg) + "Number of Candidate Properties = " + candidateProperties.size();
            logMsg = String.valueOf(logMsg) + "; Number of Properties in profile = " + profileProps.size();
            logMsg = String.valueOf(logMsg) + "; Number of Merged Effective Properties = " + mergedProps.size();
            ProfilePropertyProviderImpl.getLogger().finer(logMsg);
        }
        return mergedProps;
    }

    public IConnectionProfile getConnectionProfile(Properties candidateProperties, Object connPropContext) {
        String profileName;
        IConnectionProfile profile = null;
        try {
            profile = this.getConnectionProfileImpl(candidateProperties, connPropContext);
        }
        catch (OdaException ex) {
            ProfilePropertyProviderImpl.getLogger().warning(ProfilePropertyProviderImpl.getStackTraceStrings(ex));
        }
        if (profile == null && (profileName = this.getProfileName(candidateProperties)) != null && !profileName.isEmpty()) {
            ProfilePropertyProviderImpl.getLogger().warning("No connection profile is found by its specified name: " + profileName);
        }
        return profile;
    }

    private IConnectionProfile getConnectionProfileImpl(Properties candidateProperties, Object connPropContext) throws OdaException {
        if (candidateProperties == null || candidateProperties.isEmpty()) {
            return null;
        }
        String profileName = this.getProfileName(candidateProperties);
        if (profileName == null) {
            return null;
        }
        this.m_profileStoreFileExt = null;
        File profileStore = this.getProfileStoreFile(candidateProperties, connPropContext);
        IConnectionProfile profile = OdaProfileExplorer.getInstance().getProfileByName(profileName, profileStore, this.getProfileStoreFileOriginalExt(candidateProperties));
        return profile;
    }

    private String getProfileStoreFileOriginalExt(Properties connectionProps) {
        if (this.m_profileStoreFileExt != null) {
            return this.m_profileStoreFileExt;
        }
        return connectionProps.getProperty(PROFILE_STORE_FILE_ORIGINAL_EXT);
    }

    protected String getProfileName(Properties candidateProperties) {
        String profileName = candidateProperties.getProperty("OdaConnProfileName");
        if (profileName == null || profileName.length() == 0) {
            return null;
        }
        return profileName;
    }

    private boolean hasProfileName(Properties candidateProperties) {
        String profileName = this.getProfileName(candidateProperties);
        return profileName != null;
    }

    private File getProfileStoreFile(Properties candidateProperties, Object connPropContext) throws OdaException {
        File profileStore = this.getProfileStoreFile(connPropContext);
        if (profileStore == null) {
            profileStore = this.getProfileStoreFileFromProperties(candidateProperties, connPropContext);
        }
        if (profileStore != null) {
            Boolean refreshProfileStore = ProviderUtil.getReloadProfileStoreContextValue((Object)connPropContext);
            if (refreshProfileStore == null) {
                refreshProfileStore = this.m_refreshProfileStore;
            }
            if (refreshProfileStore.booleanValue()) {
                OdaProfileExplorer.getInstance().refresh();
            }
        }
        return profileStore;
    }

    protected File getProfileStoreFile(Object connPropContext) {
        if (connPropContext == null || !(connPropContext instanceof Map)) {
            return null;
        }
        Object propValue = ((Map)connPropContext).get("OdaConnProfileStore");
        if (propValue == null) {
            return null;
        }
        if (propValue instanceof File && ((File)propValue).exists()) {
            return (File)propValue;
        }
        ProfilePropertyProviderImpl.getLogger().warning("getProfileStoreFile( Object ): Ignoring the PROFILE_STORE_FILE_PROP_KEY object in Connection Property Context.  The specified object must be an existing File.");
        return null;
    }

    protected File getProfileStoreFile(Properties candidateProperties) {
        try {
            return this.getProfileStoreFileFromProperties(candidateProperties, null);
        }
        catch (OdaException odaException) {
            return null;
        }
    }

    private File getProfileStoreFileFromProperties(Properties candidateProperties, Object connPropContext) throws OdaException {
        if (!this.hasProfileStoreFilePath(candidateProperties)) {
            return null;
        }
        String profileStoreFilePath = this.getProfileStoreFilePath(candidateProperties);
        File profileStoreFile = this.getAbsoluteProfileStoreFile(profileStoreFilePath, connPropContext);
        if (profileStoreFile != null) {
            return profileStoreFile;
        }
        ProfilePropertyProviderImpl.getLogger().warning("getProfileStoreFileFromProperties(Properties,Object): The PROFILE_STORE_FILE_PATH_PROP_KEY value (" + profileStoreFilePath + ") specified in connection properties does not exist in the file system.");
        return null;
    }

    private String getProfileStoreFilePath(Properties candidateProperties) {
        String profileStoreFilePath = candidateProperties.getProperty("OdaConnProfileStorePath");
        if (profileStoreFilePath == null || profileStoreFilePath.length() == 0) {
            return null;
        }
        return profileStoreFilePath;
    }

    private boolean hasProfileStoreFilePath(Properties candidateProperties) {
        String profileStoreFilePath = this.getProfileStoreFilePath(candidateProperties);
        return profileStoreFilePath != null;
    }

    protected File getProfileStoreFile(String filePath) {
        try {
            return this.getAbsoluteProfileStoreFile(filePath, null);
        }
        catch (OdaException odaException) {
            return null;
        }
    }

    private File getAbsoluteProfileStoreFile(String filePath, Object connPropContext) throws OdaException {
        if (filePath == null || filePath.length() == 0) {
            return null;
        }
        File file = new File(filePath);
        if (file.exists()) {
            return file;
        }
        File resolvedStoreFile = null;
        OdaException relativePathEx = null;
        try {
            resolvedStoreFile = this.resolveRelativePath(filePath, connPropContext);
        }
        catch (OdaException ex) {
            relativePathEx = ex;
        }
        if (resolvedStoreFile != null && resolvedStoreFile.exists()) {
            String relativeFileExt = ProfilePropertyProviderImpl.getFileExtension(filePath);
            if (relativeFileExt != null && !relativeFileExt.equals(ProfilePropertyProviderImpl.getFileExtension(resolvedStoreFile.getPath()))) {
                this.m_profileStoreFileExt = relativeFileExt;
            }
            return resolvedStoreFile;
        }
        OdaException invalidUrlEx = null;
        try {
            URL url = new URL(filePath);
            return new File(PluginResourceLocator.toFileURL((URL)url).toURI());
        }
        catch (Exception ex) {
            ProfilePropertyProviderImpl.getLogger().fine("getAbsoluteProfileStoreFile(String,Object): " + ex.toString());
            invalidUrlEx = new OdaException((Throwable)ex);
            if (relativePathEx != null) {
                relativePathEx.setNextException(invalidUrlEx);
                throw relativePathEx;
            }
            throw invalidUrlEx;
        }
    }

    private File resolveRelativePath(String filePath, Object connPropContext) throws OdaException {
        if (connPropContext == null || !(connPropContext instanceof Map)) {
            return null;
        }
        Object resourceIdentifiersObj = ((Map)connPropContext).get("org.eclipse.datatools.connectivity.oda.util_consumerResourceIds");
        if (resourceIdentifiersObj == null) {
            ProfilePropertyProviderImpl.getLogger().warning(Messages.bind((String)Messages.propertyProvider_NO_RESOURCE_IDENTIFIERS, (Object)filePath));
            return null;
        }
        URI fileURI = ResourceIdentifiers.encodeToURI((String)filePath);
        URI resolvedFilePathURI = ResourceIdentifiers.resolveApplResource(resourceIdentifiersObj, (URI)fileURI);
        if (resolvedFilePathURI != null && !resolvedFilePathURI.equals(fileURI)) {
            return new File(resolvedFilePathURI);
        }
        throw new OdaException(Messages.bind((String)Messages.propertyProvider_UNABLE_TO_RESOLVE_PATH, (Object[])new Object[]{resourceIdentifiersObj.getClass().getName(), fileURI, ResourceIdentifiers.getApplResourceBaseURI(resourceIdentifiersObj)}));
    }

    private static String getFileExtension(String filename) {
        int fileExtSeparatorIndex = filename.lastIndexOf(FILE_EXT_SEPARATOR);
        String fileExtension = null;
        if (fileExtSeparatorIndex >= 0 && filename.length() > fileExtSeparatorIndex + 1) {
            fileExtension = filename.substring(fileExtSeparatorIndex + 1);
        }
        return fileExtension;
    }

    public void setRefreshProfileStore(boolean refreshProfileStore) {
        this.m_refreshProfileStore = refreshProfileStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Logger getLogger() {
        if (sm_logger != null) return sm_logger;
        Class<ProfilePropertyProviderImpl> clazz = ProfilePropertyProviderImpl.class;
        synchronized (ProfilePropertyProviderImpl.class) {
            if (sm_logger != null) return sm_logger;
            sm_logger = Logger.getLogger(sm_className);
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_logger;
        }
    }

    private static String getStackTraceStrings(Throwable ex) {
        String logMsg = String.valueOf(ex.toString()) + "\n";
        Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
        StackTraceElement[] stacks = cause.getStackTrace();
        int i = 0;
        while (i < stacks.length) {
            logMsg = String.valueOf(logMsg) + stacks[i].toString() + "\n";
            ++i;
        }
        return logMsg;
    }
}

