/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.computations;

import org.eclipse.birt.chart.internal.computations.Matrix;

public class MatrixDecomposition {
    private double[][] data;
    private int m;

    public MatrixDecomposition(Matrix A) {
        this.data = A.getArrayCopy();
        this.m = A.getRowDimension();
    }

    protected Matrix decomposition() {
        return this.ludecomposition();
    }

    private Matrix ludecomposition() {
        int k;
        double multiple;
        int j;
        double[][] temp = new double[this.m][2 * this.m];
        int i = 0;
        while (i < this.m) {
            temp[i][this.m + i] = 1.0;
            j = 0;
            while (j < this.m) {
                temp[i][j] = this.data[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.m) {
            j = 0;
            while (j < i) {
                if (temp[i][j] != 0.0) {
                    multiple = temp[i][j] / temp[j][j];
                    k = 0;
                    while (k < 2 * this.m) {
                        double[] dArray = temp[i];
                        int n = k;
                        dArray[n] = dArray[n] - temp[j][k] * multiple;
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        i = this.m - 1;
        while (i >= 0) {
            j = this.m - 1;
            while (j > i) {
                if (temp[i][j] != 0.0) {
                    multiple = temp[i][j] / temp[j][j];
                    k = 0;
                    while (k < 2 * this.m) {
                        double[] dArray = temp[i];
                        int n = k;
                        dArray[n] = dArray[n] - temp[j][k] * multiple;
                        ++k;
                    }
                }
                --j;
            }
            --i;
        }
        i = 0;
        while (i < this.m) {
            if (temp[i][i] == 0.0) {
                throw new IllegalArgumentException("Matrix is singular.");
            }
            if (temp[i][i] != 1.0) {
                double multiple2 = temp[i][i];
                int j2 = 0;
                while (j2 < 2 * this.m) {
                    double[] dArray = temp[i];
                    int n = j2++;
                    dArray[n] = dArray[n] / multiple2;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.m) {
            int j3 = 0;
            while (j3 < this.m) {
                this.data[i][j3] = temp[i][j3 + this.m];
                ++j3;
            }
            ++i;
        }
        return new Matrix(this.data, this.m, this.m);
    }
}

