/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;

public final class DominatorsSummary {
    private ClassDominatorRecord[] classDominatorRecords;
    private ClassloaderDominatorRecord[] classloaderDominatorRecords;
    private ISnapshot snapshot;
    private Object data;
    public static final Comparator<Object> COMPARE_BY_NAME = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof ClassDominatorRecord) {
                return ((ClassDominatorRecord)o1).getClassName().compareTo(((ClassDominatorRecord)o2).getClassName());
            }
            return ((ClassloaderDominatorRecord)o1).getName().compareTo(((ClassloaderDominatorRecord)o2).getName());
        }
    };
    public static final Comparator<Object> COMPARE_BY_DOMINATORS = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            int c1 = 0;
            int c2 = 0;
            if (o1 instanceof ClassDominatorRecord) {
                c1 = ((ClassDominatorRecord)o1).getDominatorCount();
                c2 = ((ClassDominatorRecord)o2).getDominatorCount();
            } else {
                c1 = ((ClassloaderDominatorRecord)o1).getDominatorCount();
                c2 = ((ClassloaderDominatorRecord)o2).getDominatorCount();
            }
            return c1 > c2 ? 1 : (c1 == c2 ? 0 : -1);
        }
    };
    public static final Comparator<Object> COMPARE_BY_DOMINATED = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            int c1 = 0;
            int c2 = 0;
            if (o1 instanceof ClassDominatorRecord) {
                c1 = ((ClassDominatorRecord)o1).getDominatedCount();
                c2 = ((ClassDominatorRecord)o2).getDominatedCount();
            } else {
                c1 = ((ClassloaderDominatorRecord)o1).getDominatedCount();
                c2 = ((ClassloaderDominatorRecord)o2).getDominatedCount();
            }
            return c1 > c2 ? 1 : (c1 == c2 ? 0 : -1);
        }
    };
    public static final Comparator<Object> COMPARE_BY_DOMINATED_HEAP_SIZE = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            long c1 = 0L;
            long c2 = 0L;
            if (o1 instanceof ClassDominatorRecord) {
                c1 = ((ClassDominatorRecord)o1).getDominatedNetSize();
                c2 = ((ClassDominatorRecord)o2).getDominatedNetSize();
            } else {
                c1 = ((ClassloaderDominatorRecord)o1).getDominatedNetSize();
                c2 = ((ClassloaderDominatorRecord)o2).getDominatedNetSize();
            }
            return c1 > c2 ? 1 : (c1 == c2 ? 0 : -1);
        }
    };
    public static final Comparator<Object> COMPARE_BY_DOMINATOR_HEAP_SIZE = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            long c1 = 0L;
            long c2 = 0L;
            if (o1 instanceof ClassDominatorRecord) {
                c1 = ((ClassDominatorRecord)o1).getDominatorNetSize();
                c2 = ((ClassDominatorRecord)o2).getDominatorNetSize();
            } else {
                c1 = ((ClassloaderDominatorRecord)o1).getDominatorNetSize();
                c2 = ((ClassloaderDominatorRecord)o2).getDominatorNetSize();
            }
            return c1 > c2 ? 1 : (c1 == c2 ? 0 : -1);
        }
    };
    public static final Comparator<Object> COMPARE_BY_DOMINATED_RETAINED_HEAP_SIZE = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            long c1 = 0L;
            long c2 = 0L;
            if (o1 instanceof ClassDominatorRecord) {
                c1 = ((ClassDominatorRecord)o1).getDominatedRetainedSize();
                c2 = ((ClassDominatorRecord)o2).getDominatedRetainedSize();
            } else {
                c1 = ((ClassloaderDominatorRecord)o1).getDominatedRetainedSize();
                c2 = ((ClassloaderDominatorRecord)o2).getDominatedRetainedSize();
            }
            return c1 > c2 ? 1 : (c1 == c2 ? 0 : -1);
        }
    };
    public static final Comparator<Object> COMPARE_BY_DOMINATOR_RETAINED_HEAP_SIZE = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            long c1 = 0L;
            long c2 = 0L;
            if (o1 instanceof ClassDominatorRecord) {
                c1 = ((ClassDominatorRecord)o1).getDominatorRetainedSize();
                c2 = ((ClassDominatorRecord)o2).getDominatorRetainedSize();
            } else {
                c1 = ((ClassloaderDominatorRecord)o1).getDominatorRetainedSize();
                c2 = ((ClassloaderDominatorRecord)o2).getDominatorRetainedSize();
            }
            return c1 > c2 ? 1 : (c1 == c2 ? 0 : -1);
        }
    };

    public DominatorsSummary(ClassDominatorRecord[] classDominatorRecords, ISnapshot snapshot) {
        this.classDominatorRecords = classDominatorRecords;
        this.snapshot = snapshot;
        ClassDominatorRecord[] classDominatorRecordArray = classDominatorRecords;
        int n = classDominatorRecords.length;
        int n2 = 0;
        while (n2 < n) {
            ClassDominatorRecord record = classDominatorRecordArray[n2];
            record.summary = this;
            ++n2;
        }
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public ClassDominatorRecord[] getClassDominatorRecords() {
        return this.classDominatorRecords;
    }

    public ClassloaderDominatorRecord[] getClassloaderDominatorRecords() {
        return this.getClassloaderDominatorRecords(ClassloaderDominatorRecord.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C extends ClassloaderDominatorRecord> C[] getClassloaderDominatorRecords(Class<C> factoryClass) {
        DominatorsSummary dominatorsSummary = this;
        synchronized (dominatorsSummary) {
            if (this.classloaderDominatorRecords == null) {
                this.classloaderDominatorRecords = this.load(factoryClass);
            }
        }
        return this.classloaderDominatorRecords;
    }

    private ClassloaderDominatorRecord[] load(Class<ClassloaderDominatorRecord> factoryClass) {
        try {
            HashMap<Integer, ClassloaderDominatorRecord> map = new HashMap<Integer, ClassloaderDominatorRecord>();
            ClassDominatorRecord[] classDominatorRecordArray = this.classDominatorRecords;
            int n = this.classDominatorRecords.length;
            int n2 = 0;
            while (n2 < n) {
                ClassDominatorRecord record = classDominatorRecordArray[n2];
                ClassloaderDominatorRecord clr = (ClassloaderDominatorRecord)map.get(record.getClassloaderId());
                if (clr == null) {
                    clr = factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    map.put(record.getClassloaderId(), clr);
                    clr.setId(record.getClassloaderId());
                    if (clr.getId() == -1) {
                        clr.name = "<ROOT>";
                    } else {
                        IObject object = this.snapshot.getObject(clr.id);
                        clr.name = object.getClassSpecificName();
                        if (clr.name == null) {
                            clr.name = object.getTechnicalName();
                        }
                    }
                }
                clr.dominated += record.getDominatedCount();
                clr.dominator += record.getDominatorCount();
                clr.dominatedNetSize += record.getDominatedNetSize();
                clr.dominatorNetSize += record.getDominatorNetSize();
                clr.records.add(record);
                ++n2;
            }
            return map.values().toArray(new ClassloaderDominatorRecord[map.size()]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Comparator<Object> reverseComparator(final Comparator<Object> comparator) {
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return comparator.compare(o2, o1);
            }
        };
    }

    public static class ClassDominatorRecord {
        DominatorsSummary summary;
        String className;
        int classloaderId;
        int classId;
        long dominatedNetSize;
        long dominatorNetSize;
        long dominatedRetainedSize;
        long dominatorRetainedSize;
        SetInt dominated = new SetInt(500);
        SetInt dominator = new SetInt(500);

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public int getClassId() {
            return this.classId;
        }

        public void setClassId(int classId) {
            this.classId = classId;
        }

        public long getDominatedNetSize() {
            return this.dominatedNetSize;
        }

        public long getDominatorNetSize() {
            return this.dominatorNetSize;
        }

        public long getDominatedRetainedSize() {
            return this.dominatedRetainedSize;
        }

        public void setDominatedRetainedSize(long dominatedRetainedSize) {
            this.dominatedRetainedSize = dominatedRetainedSize;
        }

        public long getDominatorRetainedSize() {
            return this.dominatorRetainedSize;
        }

        public void setDominatorRetainedSize(long dominatorRetainedSize) {
            this.dominatorRetainedSize = dominatorRetainedSize;
        }

        public int getDominatedCount() {
            return this.dominated.size();
        }

        public int getDominatorCount() {
            return this.dominator.size();
        }

        public int getClassloaderId() {
            return this.classloaderId;
        }

        public void setClassloaderId(int classloaderId) {
            this.classloaderId = classloaderId;
        }

        public boolean addDominated(int objectId) {
            return this.dominated.add(objectId);
        }

        public boolean addDominator(int objectId) {
            return this.dominator.add(objectId);
        }

        public void addDominatedNetSize(long size) {
            this.dominatedNetSize += size;
        }

        public void addDominatorNetSize(long size) {
            this.dominatorNetSize += size;
        }

        public int[] getDominated() {
            return this.dominated.toArray();
        }

        public int[] getDominators() {
            return this.dominator.toArray();
        }

        public DominatorsSummary getSummary() {
            return this.summary;
        }
    }

    public static class ClassloaderDominatorRecord {
        protected List<ClassDominatorRecord> records = new ArrayList<ClassDominatorRecord>();
        protected String name;
        protected int id;
        long dominatedNetSize;
        long dominatorNetSize;
        long dominatorRetainedSize;
        long dominatedRetainedSize;
        int dominated;
        int dominator;

        public String getName() {
            return this.name;
        }

        public long getDominatedNetSize() {
            return this.dominatedNetSize;
        }

        public int getDominatedCount() {
            return this.dominated;
        }

        public int getDominatorCount() {
            return this.dominator;
        }

        public long getDominatorNetSize() {
            return this.dominatorNetSize;
        }

        public List<ClassDominatorRecord> getRecords() {
            return this.records;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public long getDominatedRetainedSize() {
            return this.dominatedRetainedSize;
        }

        public void setDominatedRetainedSize(long dominatedRetainedSize) {
            this.dominatedRetainedSize = dominatedRetainedSize;
        }

        public long getDominatorRetainedSize() {
            return this.dominatorRetainedSize;
        }

        public void setDominatorRetainedSize(long dominatorRetainedSize) {
            this.dominatorRetainedSize = dominatorRetainedSize;
        }
    }
}

