/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.NormalizedNameClass;
import com.thaiopensource.xml.util.Name;
import java.util.Map;
import java.util.Set;

public class NormalizedNsNameClass
extends NormalizedNameClass {
    private final Map<String, ? extends Set<String>> nsMap;
    private final Set<String> includedNamespaces;

    public NormalizedNsNameClass(Set<Name> set, Map<String, ? extends Set<String>> map) {
        super(set);
        this.nsMap = map;
        this.includedNamespaces = this.immutable(map.keySet());
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.nsMap.isEmpty();
    }

    @Override
    public boolean contains(Name name) {
        Set<String> set = this.nsMap.get(name.getNamespaceUri());
        if (set == null) {
            return super.contains(name);
        }
        return !set.contains(name.getLocalName());
    }

    @Override
    public Set<String> getIncludedNamespaces() {
        return this.includedNamespaces;
    }

    @Override
    public Set<String> getExcludedLocalNames(String string) {
        return this.nsMap.get(string);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.nsMap.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof NormalizedNsNameClass)) {
            return false;
        }
        NormalizedNsNameClass normalizedNsNameClass = (NormalizedNsNameClass)object;
        if (!this.nsMap.equals(normalizedNsNameClass.nsMap)) {
            return false;
        }
        return this.equal(this, normalizedNsNameClass);
    }

    @Override
    boolean includesNamespace(String string) {
        return this.getIncludedNamespaces().contains(string);
    }
}

