/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.itcl.internal.core.classes;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.itcl.internal.core.IncrTCLPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class IncrTclClassesManager
implements IResourceChangeListener {
    private static final String CLASSES_TAG = "classes";
    private static final String PATH_ITCL_CLASSES = ".itcl_cl";
    private static final String CLASS_TAG = "class";
    private static IncrTclClassesManager sInstance;
    private boolean dirty = false;
    private int changes = 0;
    private Set<String> classNames = new HashSet<String>();

    public void clean() {
        this.classNames.clear();
    }

    public void add(String name) {
        this.classNames.add(name);
        this.dirty = true;
        ++this.changes;
        if (this.changes > 10) {
            this.changes = 0;
            this.save();
        }
    }

    public void remove(String name) {
        this.classNames.remove(name);
    }

    public boolean isClass(String name) {
        return this.classNames.contains(name);
    }

    public void startup() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.load();
    }

    private synchronized void load() {
        block9: {
            IPath packages = IncrTCLPlugin.getDefault().getStateLocation().append(PATH_ITCL_CLASSES);
            File packagesFile = packages.toFile();
            if (packagesFile.exists()) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                try {
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    BufferedInputStream stream = new BufferedInputStream(new FileInputStream(packagesFile));
                    Document document = builder.parse(stream);
                    stream.close();
                    this.populate(document.getDocumentElement());
                }
                catch (ParserConfigurationException e) {
                    if (DLTKCore.DEBUG) {
                        e.printStackTrace();
                    }
                }
                catch (FileNotFoundException e) {
                    if (DLTKCore.DEBUG) {
                        e.printStackTrace();
                    }
                }
                catch (SAXException e) {
                    if (DLTKCore.DEBUG) {
                        e.printStackTrace();
                    }
                }
                catch (IOException e) {
                    if (!DLTKCore.DEBUG) break block9;
                    e.printStackTrace();
                }
            }
        }
        this.dirty = false;
    }

    private synchronized void populate(Element documentElement) {
        NodeList childNodes = documentElement.getChildNodes();
        int length = childNodes.getLength();
        int i = 0;
        while (i < length) {
            Element el;
            String value;
            Node child = childNodes.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equalsIgnoreCase(CLASS_TAG) && (value = (el = (Element)child).getAttribute("value")).trim().length() > 0) {
                this.add(value);
            }
            ++i;
        }
    }

    private synchronized void save() {
        block9: {
            if (!this.dirty) {
                return;
            }
            this.dirty = false;
            IPath packages = IncrTCLPlugin.getDefault().getStateLocation().append(PATH_ITCL_CLASSES);
            File packagesFile = packages.toFile();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.newDocument();
                this.save(document);
                FileOutputStream fos = new FileOutputStream(packagesFile, false);
                BufferedOutputStream bos = new BufferedOutputStream(fos, 2048);
                TransformerFactory serFactory = TransformerFactory.newInstance();
                Transformer transformer = serFactory.newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                DOMSource source = new DOMSource(document);
                StreamResult outputTarget = new StreamResult(bos);
                transformer.transform(source, outputTarget);
                bos.close();
                fos.close();
            }
            catch (ParserConfigurationException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (FileNotFoundException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (TransformerException e) {
                if (!DLTKCore.DEBUG) break block9;
                e.printStackTrace();
            }
        }
    }

    private void save(Document doc) {
        Element packages = doc.createElement(CLASSES_TAG);
        doc.appendChild(packages);
        for (String value : this.classNames) {
            Element el = doc.createElement(CLASS_TAG);
            el.setAttribute("value", value);
            packages.appendChild(el);
        }
    }

    public void shutdown() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.save();
    }

    public static IncrTclClassesManager getDefault() {
        if (sInstance == null) {
            sInstance = new IncrTclClassesManager();
        }
        return sInstance;
    }

    public void resourceChanged(IResourceChangeEvent event) {
    }

    public boolean isClass(IProject project, String className) {
        return this.classNames.contains(className);
    }
}

