/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.js.util;

import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WindowsRegistryUtil {
    private static final Pattern REGISTRY_PATTERN = Pattern.compile("HKEY_.*\\r\\n\\s*\\S+\\s+REG_SZ\\s+(.+)");

    public static String readKeyValue(String location, String key) {
        try {
            Process process = Runtime.getRuntime().exec("reg query \"" + location + "\" /v " + key);
            InputStream is = process.getInputStream();
            StringBuilder sb = new StringBuilder();
            byte[] buffer = new byte[512];
            int i = is.read(buffer);
            while (i != -1) {
                sb.append(new String(buffer));
                i = is.read(buffer);
            }
            String output = sb.toString().trim();
            Matcher m = REGISTRY_PATTERN.matcher(output);
            if (m.matches()) {
                return m.group(1);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

