/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.rewrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.core.ast.nodes.ASTParser;
import org.eclipse.php.core.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.UseStatement;
import org.eclipse.php.core.ast.nodes.UseStatementPart;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.ast.rewrite.ImportRewriteAnalyzer;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public final class ImportRewrite {
    public static final String ENCLOSING_TYPE_SEPARATOR = "\\";
    private static final char FUNCTION_PREFIX = 'f';
    private static final char CONSTANT_PREFIX = 'c';
    private static final char NORMAL_PREFIX = 'n';
    private static final char ALIAS_PREFIX = 'a';
    private final ImportRewriteContext defaultContext;
    private final ISourceModule compilationUnit;
    private final Program astRoot;
    private final Map<NamespaceDeclaration, Boolean> restoreExistingImports = new HashMap<NamespaceDeclaration, Boolean>();
    private final Map<NamespaceDeclaration, List<String>> existingImports;
    private String[] importOrder;
    private Map<NamespaceDeclaration, List<String>> addedImports;
    private Map<NamespaceDeclaration, List<String>> removedImports;
    private String[] createdImports;
    private boolean filterImplicitImports;

    public static ImportRewrite create(Program astRoot, boolean restoreExistingImports) {
        if (astRoot == null) {
            throw new IllegalArgumentException("AST must not be null");
        }
        ISourceModule typeRoot = astRoot.getSourceModule();
        HashMap<NamespaceDeclaration, List<String>> existingImport = null;
        if (restoreExistingImports) {
            existingImport = new HashMap<NamespaceDeclaration, List<String>>();
            for (Map.Entry<NamespaceDeclaration, List<UseStatement>> entry : astRoot.getUseStatements().entrySet()) {
                ArrayList<String> imports = new ArrayList<String>();
                for (UseStatement useStatement : entry.getValue()) {
                    for (UseStatementPart part : useStatement.parts()) {
                        StringBuilder buf = new StringBuilder();
                        if (part.getAlias() != null) {
                            buf.append('a');
                            buf.append(part.getAlias().getName());
                        } else {
                            buf.append('n');
                            buf.append(part.getFullUseStatementName());
                        }
                        imports.add(buf.toString());
                    }
                }
                existingImport.put(entry.getKey(), imports);
            }
        }
        return new ImportRewrite(typeRoot, astRoot, existingImport);
    }

    private ImportRewrite(ISourceModule cu, Program astRoot, Map<NamespaceDeclaration, List<String>> existingImports) {
        this.compilationUnit = cu;
        this.astRoot = astRoot;
        List<NamespaceDeclaration> namespaces = astRoot.getNamespaceDeclarations();
        if (existingImports != null) {
            this.existingImports = existingImports;
            if (namespaces.size() > 0) {
                for (NamespaceDeclaration namespace : namespaces) {
                    this.restoreExistingImports.put(namespace, !existingImports.get(namespace).isEmpty());
                }
            } else {
                this.restoreExistingImports.put(null, !existingImports.get(null).isEmpty());
            }
        } else {
            this.existingImports = new HashMap<NamespaceDeclaration, List<String>>();
            if (namespaces.size() > 0) {
                for (NamespaceDeclaration namespace : namespaces) {
                    this.restoreExistingImports.put(namespace, false);
                    this.existingImports.put(namespace, new ArrayList());
                }
            } else {
                this.restoreExistingImports.put(null, false);
                this.existingImports.put(null, new ArrayList());
            }
        }
        this.filterImplicitImports = true;
        this.defaultContext = new ImportRewriteContext(){

            @Override
            public int findInContext(NamespaceDeclaration namespace, String qualifier, String name, int kind) {
                return ImportRewrite.this.findInImports(namespace, qualifier, name, kind);
            }
        };
        this.addedImports = null;
        this.removedImports = null;
        this.createdImports = null;
        this.importOrder = CharOperation.NO_STRINGS;
    }

    public void setImportOrder(String[] order) {
        if (order == null) {
            throw new IllegalArgumentException("Order must not be null");
        }
        this.importOrder = order;
    }

    public ISourceModule getSourceModule() {
        return this.compilationUnit;
    }

    public Program getProgram() {
        return this.astRoot;
    }

    public ImportRewriteContext getDefaultImportRewriteContext() {
        return this.defaultContext;
    }

    public void setFilterImplicitImports(boolean filterImplicitImports) {
        this.filterImplicitImports = filterImplicitImports;
    }

    private static int compareImport(char prefix, String qualifier, String name, String curr) {
        if (curr.charAt(0) == 'a' && curr.endsWith(name)) {
            return 3;
        }
        if (curr.charAt(0) != prefix || !curr.endsWith(name)) {
            return 2;
        }
        if ((curr = curr.substring(1)).length() == name.length()) {
            if (qualifier.length() == 0) {
                return 1;
            }
            return 3;
        }
        int dotPos = curr.length() - name.length() - 1;
        if (curr.charAt(dotPos) != '\\') {
            return 2;
        }
        if (qualifier.length() != dotPos || !curr.startsWith(qualifier)) {
            return 3;
        }
        return 1;
    }

    final int findInImports(NamespaceDeclaration namespace, String qualifier, String name, int kind) {
        if (this.existingImports.get(namespace) == null) {
            this.existingImports.put(namespace, new ArrayList());
        }
        List<String> imports = this.existingImports.get(namespace);
        char prefix = switch (kind) {
            case 3 -> 'f';
            case 2 -> 'c';
            default -> 'n';
        };
        int i = imports.size() - 1;
        while (i >= 0) {
            String curr = imports.get(i);
            int res = ImportRewrite.compareImport(prefix, qualifier, name, curr);
            if (res != 2) {
                return res;
            }
            --i;
        }
        return 2;
    }

    public String addImport(NamespaceDeclaration namespace, String qualifiedTypeName, ImportRewriteContext context) {
        return this.internalAddImport(namespace, qualifiedTypeName, null, 1, context);
    }

    public String addImport(NamespaceDeclaration namespace, String qualifiedTypeName, String alias, int importKind, ImportRewriteContext context) {
        return this.internalAddImport(namespace, qualifiedTypeName, alias, importKind, context);
    }

    public String addImport(NamespaceDeclaration namespace, String qualifiedTypeName) {
        return this.addImport(namespace, qualifiedTypeName, this.defaultContext);
    }

    public String addImport(NamespaceDeclaration namespace, String qualifiedTypeName, int importKind) {
        return this.addImport(namespace, qualifiedTypeName, null, importKind, this.defaultContext);
    }

    public String addImport(NamespaceDeclaration namespace, String qualifiedTypeName, String alias) {
        return this.addImport(namespace, qualifiedTypeName, alias, 1, this.defaultContext);
    }

    public String addImport(NamespaceDeclaration namespace, String qualifiedTypeName, String alias, int importKind) {
        return this.addImport(namespace, qualifiedTypeName, alias, importKind, this.defaultContext);
    }

    private String internalAddImport(NamespaceDeclaration namespace, String fullTypeName, String alias, int importKind, ImportRewriteContext context) {
        int res;
        String typeName;
        String typeContainerName;
        int idx = fullTypeName.lastIndexOf(92);
        if (idx != -1) {
            typeContainerName = fullTypeName.substring(0, idx);
            typeName = fullTypeName.substring(idx + 1);
        } else {
            typeContainerName = "";
            typeName = fullTypeName;
        }
        if (context == null) {
            context = this.defaultContext;
        }
        if (alias != null) {
            typeName = alias;
            fullTypeName = String.valueOf(fullTypeName) + " as " + alias;
        }
        if ((res = context.findInContext(namespace, typeContainerName, typeName, 1)) == 3) {
            if (alias != null) {
                return alias;
            }
            if (fullTypeName.charAt(0) != '\\') {
                fullTypeName = String.valueOf('\\') + fullTypeName;
            }
            return fullTypeName;
        }
        if (res == 2) {
            this.addEntry(namespace, String.valueOf(switch (importKind) {
                case 3 -> 'f';
                case 2 -> 'c';
                default -> 'n';
            }) + fullTypeName);
        }
        return typeName;
    }

    private void addEntry(NamespaceDeclaration namespace, String entry) {
        this.existingImports.get(namespace).add(entry);
        if (this.removedImports != null && this.removedImports.get(namespace) != null && this.removedImports.get(namespace).remove(entry)) {
            return;
        }
        if (this.addedImports == null) {
            this.addedImports = new HashMap<NamespaceDeclaration, List<String>>();
        }
        if (this.addedImports.get(namespace) == null) {
            this.addedImports.put(namespace, new ArrayList());
        }
        this.addedImports.get(namespace).add(entry);
    }

    private boolean removeEntry(NamespaceDeclaration namespace, String entry) {
        if (this.existingImports.get(namespace).remove(entry)) {
            if (this.addedImports != null && this.addedImports.get(namespace) != null && this.addedImports.get(namespace).remove(entry)) {
                return true;
            }
            if (this.removedImports == null) {
                this.removedImports = new HashMap<NamespaceDeclaration, List<String>>();
            }
            if (this.removedImports.get(namespace) == null) {
                this.removedImports.put(namespace, new ArrayList());
            }
            this.removedImports.get(namespace).add(entry);
            return true;
        }
        return false;
    }

    public boolean removeImport(NamespaceDeclaration namespace, String qualifiedName) {
        return this.removeEntry(namespace, String.valueOf('n') + qualifiedName);
    }

    public final TextEdit rewriteImports(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("Updating uses", 2);
            if (!this.hasRecordedChanges()) {
                this.createdImports = CharOperation.NO_STRINGS;
                MultiTextEdit multiTextEdit = new MultiTextEdit();
                return multiTextEdit;
            }
            Program usedAstRoot = this.astRoot;
            if (usedAstRoot == null) {
                ASTParser parser = ASTParser.newParser(this.compilationUnit);
                usedAstRoot = parser.createAST((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
            }
            ImportRewriteAnalyzer computer = new ImportRewriteAnalyzer(this.compilationUnit, usedAstRoot, this.importOrder, this.restoreExistingImports);
            computer.setFilterImplicitImports(this.filterImplicitImports);
            List<NamespaceDeclaration> namespaces = usedAstRoot.getNamespaceDeclarations();
            if (namespaces.size() > 0) {
                for (NamespaceDeclaration namespace : namespaces) {
                    this.computeImports(computer, namespace);
                }
            } else {
                this.computeImports(computer, null);
            }
            MultiTextEdit result = computer.getResultingEdits((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
            this.createdImports = computer.getCreatedImports();
            MultiTextEdit multiTextEdit = result;
            return multiTextEdit;
        }
        catch (Exception e) {
            PHPCorePlugin.log(e);
        }
        finally {
            monitor.done();
        }
        return null;
    }

    private void computeImports(ImportRewriteAnalyzer computer, NamespaceDeclaration namespace) {
        String curr;
        int i;
        if (this.addedImports != null && this.addedImports.get(namespace) != null) {
            i = 0;
            while (i < this.addedImports.get(namespace).size()) {
                curr = this.addedImports.get(namespace).get(i);
                char prefix = curr.charAt(0);
                int importType = prefix == 'f' ? 1 : (prefix == 'c' ? 2 : 0);
                computer.addImport(namespace, curr.substring(1), importType);
                ++i;
            }
        }
        if (this.removedImports != null && this.removedImports.get(namespace) != null) {
            i = 0;
            while (i < this.removedImports.get(namespace).size()) {
                curr = this.removedImports.get(namespace).get(i);
                computer.removeImport(namespace, curr.substring(1));
                ++i;
            }
        }
    }

    public String[] getCreatedImports() {
        return this.createdImports;
    }

    public String[] getAddedImports() {
        return ImportRewrite.filterFromList(this.addedImports, 'n');
    }

    public String[] getAddedFunctionImports() {
        return ImportRewrite.filterFromList(this.addedImports, 'f');
    }

    public String[] getAddedConstImports() {
        return ImportRewrite.filterFromList(this.addedImports, 'c');
    }

    public String[] getRemovedImports() {
        return ImportRewrite.filterFromList(this.removedImports, 'n');
    }

    public String[] getRemovedFunctionImports() {
        return ImportRewrite.filterFromList(this.removedImports, 'f');
    }

    public String[] getRemovedConstImports() {
        return ImportRewrite.filterFromList(this.removedImports, 'c');
    }

    public boolean hasRecordedChanges() {
        boolean hasRecordedChanges = false;
        List<NamespaceDeclaration> namespaces = this.astRoot.getNamespaceDeclarations();
        if (namespaces.size() > 0) {
            for (NamespaceDeclaration namespace : namespaces) {
                hasRecordedChanges = this.hasRecordedChanges(namespace);
                if (!hasRecordedChanges) continue;
                return hasRecordedChanges;
            }
            return hasRecordedChanges;
        }
        return this.hasRecordedChanges(null);
    }

    private boolean hasRecordedChanges(NamespaceDeclaration namespace) {
        return this.restoreExistingImports.get(namespace) == false || this.addedImports != null && this.addedImports.get(namespace) != null && !this.addedImports.get(namespace).isEmpty() || this.removedImports != null && this.removedImports.get(namespace) != null && !this.removedImports.get(namespace).isEmpty();
    }

    private static String[] filterFromList(Map<NamespaceDeclaration, List<String>> imports, char prefix) {
        if (imports == null) {
            return CharOperation.NO_STRINGS;
        }
        ArrayList<String> res = new ArrayList<String>();
        for (List<String> strings : imports.values()) {
            int i = 0;
            while (i < strings.size()) {
                String curr = strings.get(i);
                if (prefix == curr.charAt(0)) {
                    res.add(curr.substring(1));
                }
                ++i;
            }
        }
        return res.toArray(new String[res.size()]);
    }

    public static abstract class ImportRewriteContext {
        public static final int RES_NAME_FOUND = 1;
        public static final int RES_NAME_UNKNOWN = 2;
        public static final int RES_NAME_CONFLICT = 3;
        public static final int KIND_TYPE = 1;
        public static final int KIND_CONSTANT = 2;
        public static final int KIND_FUNCTION = 3;

        public abstract int findInContext(NamespaceDeclaration var1, String var2, String var3, int var4);
    }
}

