/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.command;

import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.command.MatchMappingCommand;
import org.eclipse.emf.mapping.domain.MappingDomain;

public class TypeMatchMappingCommand
extends MatchMappingCommand {
    public static Command create(MappingDomain domain, Mapping mapping) {
        return domain.createCommand(TypeMatchMappingCommand.class, new CommandParameter((Object)mapping));
    }

    public TypeMatchMappingCommand(MappingDomain domain, Mapping mapping) {
        super(domain, mapping);
    }

    @Override
    protected boolean match(Object inputObject, Object outputObject, Collection<Object> mappedObjects) {
        if (this.mappedInputs.contains(inputObject) || !this.domain.getMappingRoot().getMappings(inputObject).isEmpty()) {
            return false;
        }
        Object inputType = this.domain.getTypeClassifier(inputObject);
        if (inputType != null) {
            Object outputType = this.domain.getTypeClassifier(outputObject);
            Object convertedInputType = this.domain.getOutputTypeClassifier(inputType);
            if (outputType != null && outputType == convertedInputType) {
                mappedObjects.add(inputObject);
                return true;
            }
        }
        return false;
    }
}

