/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.event;

import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Image;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Position;

public class ImageRenderEvent
extends PrimitiveRenderEvent {
    private static final long serialVersionUID = -5467310111862210812L;
    protected transient Image img;
    protected transient Location loc;
    protected Position pos;
    protected int width = -1;
    protected int height = -1;
    protected boolean stretch = false;

    public ImageRenderEvent(Object oSource) {
        super(oSource);
    }

    public void setLocation(Location loc) {
        this.loc = loc;
    }

    public void setImage(Image img) {
        this.img = img;
    }

    public void setPosition(Position pos) {
        this.pos = pos;
    }

    public Location getLocation() {
        return this.loc;
    }

    public Image getImage() {
        return this.img;
    }

    public Position getPosition() {
        return this.pos;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setStretch(boolean val) {
        this.stretch = val;
    }

    public boolean isStretch() {
        return this.stretch;
    }

    @Override
    public PrimitiveRenderEvent copy() throws ChartException {
        ImageRenderEvent ire = new ImageRenderEvent(this.source);
        if (this.loc != null) {
            ire.setLocation(this.loc.copyInstance());
        }
        if (this.img != null) {
            ire.setImage(goFactory.copyOf(this.img));
        }
        ire.setPosition(this.pos);
        ire.setWidth(this.width);
        ire.setHeight(this.height);
        ire.setStretch(this.stretch);
        return ire;
    }

    @Override
    public void fill(IDeviceRenderer idr) throws ChartException {
        this.draw(idr);
    }

    @Override
    public void draw(IDeviceRenderer idr) throws ChartException {
        idr.drawImage(this);
    }

    @Override
    public void reset() {
        this.loc = null;
        this.pos = null;
    }
}

