/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.ui.viewer;

import java.util.ArrayList;
import java.util.EventObject;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.tcf.te.launch.core.persistence.DefaultPersistenceDelegate;
import org.eclipse.tcf.te.launch.ui.model.LaunchModel;
import org.eclipse.tcf.te.launch.ui.model.LaunchNode;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.events.ChangeEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventListener;
import org.eclipse.tcf.te.runtime.model.interfaces.IContainerModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.ui.PlatformUI;

public class LaunchNavigatorContentProvider
implements ITreeContentProvider,
IEventListener {
    private static final Object[] NO_ELEMENTS = new Object[0];
    private Viewer viewer;

    public LaunchNavigatorContentProvider() {
        EventManager.getInstance().addEventListener((IEventListener)this, ChangeEvent.class);
    }

    public Object[] getChildren(Object element) {
        if (element instanceof LaunchNode) {
            LaunchNode node = (LaunchNode)((Object)element);
            if (node.getModel().getModelRoot() instanceof IProject) {
                node.getModel();
            }
            ArrayList<IModelNode> children = new ArrayList<IModelNode>();
            if (node.isType("root")) {
                if (this.isTypeNodeVisible()) {
                    if (this.isEmptyTypeNodeVisible()) {
                        return node.getChildren();
                    }
                    IModelNode[] iModelNodeArray = node.getChildren();
                    int n = iModelNodeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IModelNode typeNode = iModelNodeArray[n2];
                        if (((IContainerModelNode)typeNode).hasChildren()) {
                            children.add(typeNode);
                        }
                        ++n2;
                    }
                    return children.toArray();
                }
                IModelNode[] iModelNodeArray = node.getChildren();
                int n = iModelNodeArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IModelNode typeNode = iModelNodeArray[n3];
                    IModelNode[] iModelNodeArray2 = ((IContainerModelNode)typeNode).getChildren();
                    int n4 = iModelNodeArray2.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        IModelNode configNode = iModelNodeArray2[n5];
                        children.add(configNode);
                        ++n5;
                    }
                    ++n3;
                }
                return children.toArray();
            }
            return node.getChildren();
        }
        LaunchModel model = LaunchModel.getLaunchModel(element);
        if (model != null) {
            if (this.isRootNodeVisible() && model.getRootNode().hasChildren()) {
                return new Object[]{model.getRootNode()};
            }
            return this.getChildren((Object)model.getRootNode());
        }
        return NO_ELEMENTS;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof LaunchNode) {
            LaunchNode node = (LaunchNode)((Object)element);
            ArrayList<IModelNode> children = new ArrayList<IModelNode>();
            if (node.isType("root")) {
                if (this.isTypeNodeVisible()) {
                    if (this.isEmptyTypeNodeVisible()) {
                        return ((LaunchNode)((Object)element)).hasChildren();
                    }
                    IModelNode[] iModelNodeArray = node.getChildren();
                    int n = iModelNodeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IModelNode typeNode = iModelNodeArray[n2];
                        if (((IContainerModelNode)typeNode).hasChildren()) {
                            children.add(typeNode);
                        }
                        ++n2;
                    }
                    return !children.isEmpty();
                }
                IModelNode[] iModelNodeArray = node.getChildren();
                int n = iModelNodeArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IModelNode typeNode = iModelNodeArray[n3];
                    IModelNode[] iModelNodeArray2 = ((IContainerModelNode)typeNode).getChildren();
                    int n4 = iModelNodeArray2.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        IModelNode configNode = iModelNodeArray2[n5];
                        children.add(configNode);
                        ++n5;
                    }
                    ++n3;
                }
                return !children.isEmpty();
            }
            return ((LaunchNode)((Object)element)).hasChildren();
        }
        LaunchModel model = LaunchModel.getLaunchModel(element);
        if (model != null) {
            if (this.isRootNodeVisible()) {
                return true;
            }
            return this.hasChildren((Object)model.getRootNode());
        }
        return false;
    }

    public Object getParent(Object element) {
        if (element instanceof LaunchNode) {
            LaunchNode node = (LaunchNode)((Object)element);
            if (node.getParent() == null || node.isType("root") || !this.isTypeNodeVisible() && node.isType("launchConfig") || !this.isRootNodeVisible() && node.isType("launchConfigType")) {
                return node.getModel().getModelRoot();
            }
            return node.getParent();
        }
        return null;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void inputChanged(final Viewer viewer, Object oldInput, Object newInput) {
        LaunchModel model;
        this.viewer = viewer;
        if (newInput != null && !newInput.equals(oldInput) && (model = LaunchModel.getLaunchModel(newInput)) != null) {
            LaunchNode lastLaunchedNode = null;
            long nodeValue = -1L;
            IModelNode[] iModelNodeArray = model.getRootNode().getChildren();
            int n = iModelNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IModelNode typeNode = iModelNodeArray[n2];
                IModelNode[] iModelNodeArray2 = ((IContainerModelNode)typeNode).getChildren();
                int n3 = iModelNodeArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    long last;
                    IModelNode launchNode = iModelNodeArray2[n4];
                    ILaunchConfiguration config = ((LaunchNode)launchNode).getLaunchConfiguration();
                    String lastLaunched = DefaultPersistenceDelegate.getAttribute((ILaunchConfiguration)config, (String)"org.eclipse.tcf.te.launch.lastLaunched", null);
                    if (lastLaunched != null && (last = Long.parseLong(lastLaunched)) > nodeValue) {
                        nodeValue = last;
                        lastLaunchedNode = (LaunchNode)launchNode;
                    }
                    ++n4;
                }
                ++n2;
            }
            if (lastLaunchedNode != null) {
                final LaunchNode node = lastLaunchedNode;
                ExecutorsUtil.executeInUI((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        viewer.setSelection((ISelection)new StructuredSelection((Object)node));
                    }
                });
            }
        }
    }

    public void dispose() {
        EventManager.getInstance().removeEventListener((IEventListener)this);
    }

    protected boolean isRootNodeVisible() {
        return true;
    }

    protected boolean isTypeNodeVisible() {
        return true;
    }

    protected boolean isEmptyTypeNodeVisible() {
        return true;
    }

    public void eventFired(EventObject event) {
        LaunchModel model;
        final Viewer viewer = this.viewer;
        if (event.getSource() instanceof LaunchModel && (model = (LaunchModel)event.getSource()) != null && viewer instanceof TreeViewer) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (viewer.getControl() != null && !viewer.getControl().isDisposed()) {
                        ((TreeViewer)viewer).refresh(LaunchNavigatorContentProvider.this.isRootNodeVisible() ? model.getRootNode() : model.getModelRoot(), true);
                    }
                }
            });
        }
    }
}

