/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.dialogs;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.php.internal.ui.util.SWTUtil;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.php.profile.ui.PHPProfileUIMessages;
import org.eclipse.php.profile.ui.ProfilerUIImages;
import org.eclipse.php.profile.ui.filters.ExecutionStatisticsFieldFilter;
import org.eclipse.php.profile.ui.filters.ExecutionStatisticsFilter;
import org.eclipse.php.profile.ui.filters.ExecutionStatisticsFilterCondition;
import org.eclipse.php.profile.ui.filters.ExecutionStatisticsFilterString;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ExecutionStatisticsFilterDialog
extends StatusDialog {
    private ExecutionStatisticsFilter fFilter;
    private Image fFilterImage;
    private List<ExecutionStatisticsFilter> fExistingFilters;
    private CTabFolder fTabFolder;
    private CTabItem fStandardTab;
    private CTabItem fAdvancedTab;
    private Text fFilterName;
    private Text fFilterString;
    private Button fCaseSensitive;
    private Button fFilterByFile;
    private Button fFilterByClass;
    private Button fFilterByFunction;
    private Button fShowInformationMatching;
    private Combo fDescriptor;
    private Text fNumber;
    private Combo fField;
    private Label fShowLabel;
    private Label fByLabel;
    private Combo fCondAttribute;
    private Combo fCondOperator;
    private Text fCondValue;
    private Table fCondTable;
    private TableViewer fCondTableViewer;
    private Button fAddButton;
    private Button fDeleteButton;
    private static final String[] fDescriptors = new String[]{PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.4"), PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.5")};
    private static final String[] fDescriptorsData = new String[]{"File name", "Class name", "Function name"};
    private static final String[] fFields = new String[]{PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.6"), PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.7"), PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.8"), PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.9"), PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.10")};
    private static final String[] fFieldsData = new String[]{"Calls Count", "Average Own Time", "Own Time", "Others Time", "Total Time"};
    private static final String[] fAttributes = new String[]{PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.11"), PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.12"), PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.13"), PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.14"), PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.15"), PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.16"), PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.17"), PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.18"), PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.19"), PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.20")};
    private static final String[] fAttributesData = new String[]{"File Name", "Class Name", "Function Name", "File Total Time", "Class Total Time", "Function Total Time", "Function Average Own Time", "Function Own Time", "Function Others Time", "Function Calls Count"};
    private static final String[] fOperators = new String[]{PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.21"), PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.22"), PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.23"), PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.24"), PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.25"), PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.26")};
    private static final String[] fOperatorsData = new String[]{"equals", "not equals", "matches", "doesn't match", "less than", "more than"};
    private static final String[] fCondTableColumns = new String[]{PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.36"), PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.37"), PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.38")};
    private static final int[] fCondTableColumnsWidths = new int[]{30, 15, 30};

    public ExecutionStatisticsFilterDialog(Shell parent, ExecutionStatisticsFilter filter, List<ExecutionStatisticsFilter> existingFilters) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle(filter == null ? PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.49") : PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.0"));
        this.fFilter = filter;
        this.fExistingFilters = existingFilters;
        this.fFilterImage = ProfilerUIImages.get("IMG_OBJ_FILTER");
    }

    private void addStandardFilterTab(CTabFolder folder) {
        Composite page = new Composite((Composite)folder, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        page.setLayout((Layout)layout);
        page.setLayoutData((Object)new GridData(1808));
        Composite filterStringComposite = new Composite(page, 0);
        filterStringComposite.setLayout((Layout)new GridLayout());
        filterStringComposite.setLayoutData((Object)new GridData(768));
        Label label = new Label(filterStringComposite, 0);
        label.setText(PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.1"));
        this.fFilterString = new Text(filterStringComposite, 2048);
        GridData data = new GridData(768);
        data.horizontalIndent = 10;
        this.fFilterString.setLayoutData((Object)data);
        this.fCaseSensitive = new Button(filterStringComposite, 32);
        this.fCaseSensitive.setText(PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.42"));
        Composite filterByComposite = new Composite(page, 0);
        filterByComposite.setLayout((Layout)new GridLayout());
        filterByComposite.setLayoutData((Object)new GridData(768));
        label = new Label(filterByComposite, 0);
        label.setText(PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.27"));
        Composite filterByGroup = new Composite(filterByComposite, 0);
        layout = new GridLayout();
        filterByGroup.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalIndent = 10;
        filterByGroup.setLayoutData((Object)data);
        this.fFilterByFile = new Button(filterByGroup, 16);
        this.fFilterByFile.setText(PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.28"));
        this.fFilterByClass = new Button(filterByGroup, 16);
        this.fFilterByClass.setText(PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.29"));
        this.fFilterByFunction = new Button(filterByGroup, 16);
        this.fFilterByFunction.setText(PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.30"));
        this.fFilterByFunction.setSelection(true);
        Composite showInformationMatchingGroup = new Composite(page, 0);
        layout = new GridLayout();
        layout.numColumns = 5;
        showInformationMatchingGroup.setLayout((Layout)layout);
        showInformationMatchingGroup.setLayoutData((Object)new GridData(768));
        this.fShowInformationMatching = new Button(showInformationMatchingGroup, 32);
        this.fShowInformationMatching.setText(PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.31"));
        data = new GridData();
        data.horizontalSpan = 5;
        this.fShowInformationMatching.setLayoutData((Object)data);
        this.fShowInformationMatching.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutionStatisticsFilterDialog.this.showInformationMatchingSelected();
            }
        });
        this.fShowLabel = new Label(showInformationMatchingGroup, 0);
        this.fShowLabel.setText(PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.32"));
        this.fDescriptor = new Combo(showInformationMatchingGroup, 8);
        int i = 0;
        while (i < fDescriptors.length) {
            this.fDescriptor.add(fDescriptors[i]);
            this.fDescriptor.setData(fDescriptors[i], (Object)fDescriptorsData[i]);
            ++i;
        }
        this.fDescriptor.select(1);
        this.fDescriptor.setLayoutData((Object)new GridData(768));
        this.fNumber = new Text(showInformationMatchingGroup, 2048);
        this.fNumber.setText("10");
        this.fNumber.setLayoutData((Object)new GridData(768));
        this.fNumber.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExecutionStatisticsFilterDialog.this.validateFieldFilter();
            }
        });
        this.fByLabel = new Label(showInformationMatchingGroup, 0);
        this.fByLabel.setText(PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.34"));
        this.fField = new Combo(showInformationMatchingGroup, 8);
        i = 0;
        while (i < fFields.length) {
            this.fField.add(fFields[i]);
            this.fField.setData(fFields[i], (Object)fFieldsData[i]);
            ++i;
        }
        this.fField.select(2);
        this.fField.setLayoutData((Object)new GridData(768));
        this.fStandardTab = new CTabItem(folder, 0);
        this.fStandardTab.setText(PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.2"));
        this.fStandardTab.setImage(this.fFilterImage);
        this.fStandardTab.setControl((Control)page);
        folder.setSelection(this.fStandardTab);
    }

    private void updateAddDeleteButtonsStatus() {
        this.fAddButton.setEnabled(this.fCondAttribute.getText().length() > 0 && this.fCondOperator.getText().length() > 0);
        this.fDeleteButton.setEnabled(((IStructuredSelection)this.fCondTableViewer.getSelection()).getFirstElement() != null);
    }

    private void addAdvancedFilterTab(CTabFolder folder) {
        Composite page = new Composite((Composite)folder, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        page.setLayout((Layout)layout);
        page.setLayoutData((Object)new GridData(1808));
        PixelConverter pixelConverter = new PixelConverter((Control)page);
        Composite condComposite = new Composite(page, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        condComposite.setLayout((Layout)layout);
        condComposite.setLayoutData((Object)new GridData(768));
        Label label = new Label(condComposite, 0);
        label.setText(PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.35"));
        GridData data = new GridData();
        data.horizontalSpan = 3;
        label.setLayoutData((Object)data);
        SelectionAdapter fAddDeleteButtonsStatusUpdater = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutionStatisticsFilterDialog.this.updateAddDeleteButtonsStatus();
                ExecutionStatisticsFilterDialog.this.validateCondition();
            }
        };
        this.fCondAttribute = new Combo(condComposite, 8);
        int i = 0;
        while (i < fAttributes.length) {
            this.fCondAttribute.add(fAttributes[i]);
            this.fCondAttribute.setData(fAttributes[i], (Object)fAttributesData[i]);
            ++i;
        }
        this.fCondAttribute.setLayoutData((Object)new GridData(768));
        this.fCondAttribute.addSelectionListener((SelectionListener)fAddDeleteButtonsStatusUpdater);
        this.fCondOperator = new Combo(condComposite, 8);
        i = 0;
        while (i < fOperators.length) {
            this.fCondOperator.add(fOperators[i]);
            this.fCondOperator.setData(fOperators[i], (Object)fOperatorsData[i]);
            ++i;
        }
        this.fCondOperator.setLayoutData((Object)new GridData(768));
        this.fCondOperator.addSelectionListener((SelectionListener)fAddDeleteButtonsStatusUpdater);
        this.fCondValue = new Text(condComposite, 2048);
        data = new GridData(768);
        data.widthHint = pixelConverter.convertWidthInCharsToPixels(30);
        this.fCondValue.setLayoutData((Object)data);
        this.fCondValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExecutionStatisticsFilterDialog.this.validateCondition();
            }
        });
        Composite condTableComposite = new Composite(page, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        condTableComposite.setLayout((Layout)layout);
        condTableComposite.setLayoutData((Object)new GridData(1808));
        this.fCondTable = new Table(condTableComposite, 68354);
        data = new GridData(1808);
        this.fCondTable.setLayoutData((Object)data);
        this.fCondTable.setHeaderVisible(true);
        this.fCondTable.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        int i2 = 0;
        while (i2 < fCondTableColumns.length) {
            int width = pixelConverter.convertWidthInCharsToPixels(fCondTableColumnsWidths[i2]);
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(width, true));
            TableColumn column = new TableColumn(this.fCondTable, 0);
            column.setText(fCondTableColumns[i2]);
            ++i2;
        }
        this.fCondTable.setLayout((Layout)tableLayout);
        this.fCondTableViewer = new TableViewer(this.fCondTable);
        this.fCondTableViewer.setUseHashlookup(true);
        this.fCondTableViewer.setContentProvider((IContentProvider)new CondTableContentProvider());
        this.fCondTableViewer.setLabelProvider((IBaseLabelProvider)new CondTableLabelProvider());
        this.fCondTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sSelection = (IStructuredSelection)ExecutionStatisticsFilterDialog.this.fCondTableViewer.getSelection();
                ExecutionStatisticsFilterCondition cond = (ExecutionStatisticsFilterCondition)((Object)sSelection.getFirstElement());
                if (cond != null) {
                    ExecutionStatisticsFilterDialog.this.fCondAttribute.setText(cond.getAttribute());
                    ExecutionStatisticsFilterDialog.this.fCondOperator.setText(cond.getOperator());
                    ExecutionStatisticsFilterDialog.this.fCondValue.setText(cond.getValue());
                }
                ExecutionStatisticsFilterDialog.this.updateAddDeleteButtonsStatus();
            }
        });
        Composite buttonsBar = new Composite(condTableComposite, 0);
        layout = new GridLayout();
        buttonsBar.setLayout((Layout)layout);
        buttonsBar.setLayoutData((Object)new GridData(2));
        this.fAddButton = new Button(buttonsBar, 0);
        this.fAddButton.setText(PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.39"));
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutionStatisticsFilterCondition cond = new ExecutionStatisticsFilterCondition();
                cond.setAttribute(ExecutionStatisticsFilterDialog.this.fCondAttribute.getText());
                cond.setOperator(ExecutionStatisticsFilterDialog.this.fCondOperator.getText());
                cond.setValue(ExecutionStatisticsFilterDialog.this.fCondValue.getText());
                ExecutionStatisticsFilterDialog.this.fCondTableViewer.add((Object)cond);
            }
        });
        this.fDeleteButton = new Button(buttonsBar, 0);
        this.fDeleteButton.setText(PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.40"));
        this.fDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sSelection = (IStructuredSelection)ExecutionStatisticsFilterDialog.this.fCondTableViewer.getSelection();
                ExecutionStatisticsFilterCondition cond = (ExecutionStatisticsFilterCondition)((Object)sSelection.getFirstElement());
                ExecutionStatisticsFilterDialog.this.fCondTableViewer.remove((Object)cond);
            }
        });
        this.fAdvancedTab = new CTabItem(folder, 0);
        this.fAdvancedTab.setText(PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.3"));
        this.fAdvancedTab.setImage(this.fFilterImage);
        this.fAdvancedTab.setControl((Control)page);
    }

    private void validateFilterName() {
        IStatus status = StatusInfo.OK_STATUS;
        String filterName = this.fFilterName.getText();
        if (filterName.length() == 0) {
            status = new StatusInfo(4, PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.43"));
        }
        if (this.fFilter == null) {
            int i = 0;
            while (i < this.fExistingFilters.size()) {
                if (this.fExistingFilters.get(i).getName().equals(filterName)) {
                    status = new StatusInfo(4, PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.44"));
                    break;
                }
                ++i;
            }
        }
        this.updateStatus(status);
    }

    private void validateFieldFilter() {
        IStatus status = StatusInfo.OK_STATUS;
        if (this.fShowInformationMatching.getSelection()) {
            String numberStr = this.fNumber.getText();
            if (numberStr.length() == 0) {
                status = new StatusInfo(4, PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.45"));
            } else {
                try {
                    Integer.parseInt(numberStr);
                }
                catch (NumberFormatException numberFormatException) {
                    status = new StatusInfo(4, PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.46"));
                }
            }
        }
        this.updateStatus(status);
    }

    private void validateCondition() {
        IStatus status = StatusInfo.OK_STATUS;
        String operator = this.fCondOperator.getText();
        String condition = this.fCondValue.getText();
        if ("less than".equals(operator) || "more than".equals(operator)) {
            try {
                Double.parseDouble(condition);
            }
            catch (NumberFormatException numberFormatException) {
                status = new StatusInfo(4, PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.47"));
            }
        } else if (condition.trim().length() == 0) {
            status = new StatusInfo(4, PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.48"));
        }
        if (status != StatusInfo.OK_STATUS) {
            this.fAddButton.setEnabled(false);
        } else {
            this.updateAddDeleteButtonsStatus();
        }
    }

    protected Control createDialogArea(Composite parent) {
        parent = (Composite)super.createDialogArea(parent);
        PixelConverter pixelConverter = new PixelConverter((Control)parent);
        Composite nameGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        nameGroup.setLayout((Layout)layout);
        Label label = new Label(nameGroup, 0);
        label.setText(PHPProfileUIMessages.getString("ExecutionStatisticsFilterDialog.41"));
        this.fFilterName = new Text(nameGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        this.fFilterName.setLayoutData((Object)data);
        this.fFilterName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExecutionStatisticsFilterDialog.this.validateFilterName();
            }
        });
        this.fTabFolder = SWTUtil.createTabFolder((Composite)parent);
        data = new GridData(1808);
        data.heightHint = pixelConverter.convertHeightInCharsToPixels(20);
        data.widthHint = pixelConverter.convertWidthInCharsToPixels(100);
        this.fTabFolder.setLayoutData((Object)data);
        this.addStandardFilterTab(this.fTabFolder);
        this.addAdvancedFilterTab(this.fTabFolder);
        this.initializeValues();
        this.updateAddDeleteButtonsStatus();
        if (this.fFilter == null) {
            this.updateStatus((IStatus)new StatusInfo(4, ""));
        }
        return parent;
    }

    private void showInformationMatchingSelected() {
        boolean status = this.fShowInformationMatching.getSelection();
        this.fShowLabel.setEnabled(status);
        this.fDescriptor.setEnabled(status);
        this.fNumber.setEnabled(status);
        this.fByLabel.setEnabled(status);
        this.fField.setEnabled(status);
    }

    private void initializeValues() {
        if (this.fFilter != null) {
            ExecutionStatisticsFieldFilter fieldFilter;
            this.fFilterName.setText(this.fFilter.getName());
            ExecutionStatisticsFilterString filterString = this.fFilter.getFilterString();
            if (filterString != null) {
                this.fFilterString.setText(filterString.getString() == null ? "" : filterString.getString());
                this.fCaseSensitive.setSelection(filterString.isCaseSensitive());
                this.fFilterByFile.setSelection("File name".equals(filterString.getFilterBy()));
                this.fFilterByClass.setSelection("Class name".equals(filterString.getFilterBy()));
                this.fFilterByFunction.setSelection("Function name".equals(filterString.getFilterBy()));
            }
            if ((fieldFilter = this.fFilter.getFieldFilter()) != null) {
                this.fShowInformationMatching.setSelection(true);
                int i = 0;
                while (i < this.fDescriptor.getItemCount()) {
                    if (this.fDescriptor.getData(this.fDescriptor.getItem(i)).equals(fieldFilter.getDescriptor())) {
                        this.fDescriptor.select(i);
                        break;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.fField.getItemCount()) {
                    if (this.fField.getData(this.fField.getItem(i)).equals(fieldFilter.getField())) {
                        this.fField.select(i);
                        break;
                    }
                    ++i;
                }
                this.fNumber.setText(Integer.toString(fieldFilter.getNumber()));
            }
        }
        this.fCondTableViewer.setInput((Object)this.fFilter);
        this.showInformationMatchingSelected();
    }

    public ExecutionStatisticsFilter getFilter() {
        return this.fFilter;
    }

    protected void okPressed() {
        if (this.fFilter == null) {
            this.fFilter = new ExecutionStatisticsFilter();
        }
        this.fFilter.setName(this.fFilterName.getText());
        String filterPattern = this.fFilterString.getText().trim();
        if (filterPattern.length() > 0) {
            ExecutionStatisticsFilterString filterString = new ExecutionStatisticsFilterString();
            filterString.setString(filterPattern);
            filterString.setCaseSensitive(this.fCaseSensitive.getSelection());
            if (this.fFilterByFile.getSelection()) {
                filterString.setFilterBy("File name");
            } else if (this.fFilterByClass.getSelection()) {
                filterString.setFilterBy("Class name");
            } else if (this.fFilterByFunction.getSelection()) {
                filterString.setFilterBy("Function name");
            }
            this.fFilter.setFilterString(filterString);
        }
        if (this.fShowInformationMatching.getSelection()) {
            ExecutionStatisticsFieldFilter fieldFilter = new ExecutionStatisticsFieldFilter();
            fieldFilter.setDescriptor(this.fDescriptor.getText());
            fieldFilter.setField(this.fField.getText());
            fieldFilter.setNumber(Integer.parseInt(this.fNumber.getText()));
            this.fFilter.setFieldFilter(fieldFilter);
        } else {
            this.fFilter.setFieldFilter(null);
        }
        TableItem[] items = this.fCondTable.getItems();
        ExecutionStatisticsFilterCondition[] conditions = new ExecutionStatisticsFilterCondition[items.length];
        int i = 0;
        while (i < items.length) {
            conditions[i] = (ExecutionStatisticsFilterCondition)((Object)items[i].getData());
            ++i;
        }
        this.fFilter.setFilterConditions(conditions);
        super.okPressed();
    }

    class CondTableContentProvider
    implements IStructuredContentProvider {
        CondTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ExecutionStatisticsFilter && ((ExecutionStatisticsFilter)((Object)inputElement)).getFilterConditions() != null) {
                return ((ExecutionStatisticsFilter)((Object)inputElement)).getFilterConditions();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class CondTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        CondTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ExecutionStatisticsFilterCondition) {
                ExecutionStatisticsFilterCondition cond = (ExecutionStatisticsFilterCondition)((Object)element);
                switch (columnIndex) {
                    case 0: {
                        return cond.getAttribute();
                    }
                    case 1: {
                        return cond.getOperator();
                    }
                    case 2: {
                        return cond.getValue();
                    }
                }
            }
            return null;
        }
    }
}

