/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.remote.CommandErrorException;
import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.internal.proxy.core.ICharacterBeanProxy;
import org.eclipse.jem.internal.proxy.core.IExpression;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.INumberBeanProxy;
import org.eclipse.jem.internal.proxy.core.IStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.remote.IREMBeanProxy;
import org.eclipse.jem.internal.proxy.remote.IREMBeanTypeProxy;
import org.eclipse.jem.internal.proxy.remote.IREMConnection;
import org.eclipse.jem.internal.proxy.remote.IREMConstantBeanTypeProxy;
import org.eclipse.jem.internal.proxy.remote.ProxyRemoteMessages;
import org.eclipse.jem.internal.proxy.remote.REMAbstractNumberBeanTypeProxy;
import org.eclipse.jem.internal.proxy.remote.REMArrayBeanTypeProxy;
import org.eclipse.jem.internal.proxy.remote.REMExpression;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyConstants;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanTypeProxyFactory;

public final class REMStandardBeanProxyFactory
implements IStandardBeanProxyFactory {
    protected final REMProxyFactoryRegistry fRegistry;
    protected final REMStandardBeanTypeProxyFactory fBeanTypeProxyFactory;
    protected final IREMBeanProxy vmServerProxy;
    private final HashMap fIDToProxiesMap = new HashMap(1000);
    private int transactionLockCount = 0;
    private ReferenceQueue queue = new ReferenceQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processQueue() {
        while (true) {
            if (Thread.interrupted()) {
                return;
            }
            HashMap hashMap = this.fIDToProxiesMap;
            synchronized (hashMap) {
                if (this.queue == null || this.transactionLockCount > 0) {
                    break;
                }
                ProxyRef pr = (ProxyRef)this.queue.poll();
                if (pr != null) {
                    if (pr.getID() != null) {
                        this.fIDToProxiesMap.remove(pr.getID());
                        this.releaseID(pr.getID());
                    }
                } else {
                    break;
                }
            }
        }
    }

    REMStandardBeanProxyFactory(REMProxyFactoryRegistry aRegistry) {
        this.fRegistry = aRegistry;
        aRegistry.registerBeanProxyFactory(this);
        this.fBeanTypeProxyFactory = (REMStandardBeanTypeProxyFactory)aRegistry.getBeanTypeProxyFactory();
        this.fBeanTypeProxyFactory.initialize(this);
        IREMBeanTypeProxy serverType = this.fBeanTypeProxyFactory.objectClass.newBeanTypeForClass(new Integer(32), "org.eclipse.jem.internal.proxy.vm.remote.RemoteVMServerThread", false);
        this.fBeanTypeProxyFactory.registerBeanTypeProxy(serverType, true);
        this.vmServerProxy = serverType.newBeanProxy(new Integer(31));
        this.registerProxy(this.vmServerProxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProxies(Collection proxies) {
        HashMap hashMap = this.fIDToProxiesMap;
        synchronized (hashMap) {
            for (IREMBeanProxy proxy : proxies) {
                ProxyRef oldRef;
                if (!(proxy instanceof IBeanTypeProxy) && proxy.getTypeProxy() instanceof IREMConstantBeanTypeProxy || (oldRef = this.fIDToProxiesMap.put(proxy.getID(), new ProxyRef(proxy.getID(), proxy, this.queue))) == null) continue;
                oldRef.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProxy(IREMBeanProxy proxy) {
        if (proxy instanceof IBeanTypeProxy || !(proxy.getTypeProxy() instanceof IREMConstantBeanTypeProxy)) {
            HashMap hashMap = this.fIDToProxiesMap;
            synchronized (hashMap) {
                ProxyRef oldRef = this.fIDToProxiesMap.put(proxy.getID(), new ProxyRef(proxy.getID(), proxy, this.queue));
                if (oldRef != null) {
                    oldRef.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseProxy(IBeanProxy proxy) {
        if (!proxy.isValid()) {
            return;
        }
        if (proxy instanceof IBeanTypeProxy && !this.fBeanTypeProxyFactory.releaseProxy((IBeanTypeProxy)proxy)) {
            return;
        }
        Integer id = ((IREMBeanProxy)proxy).getID();
        HashMap hashMap = this.fIDToProxiesMap;
        synchronized (hashMap) {
            if (id != -1) {
                ProxyRef ref = (ProxyRef)this.fIDToProxiesMap.get(id);
                if (ref == null || ref.decrUseCnt() <= 0) {
                    this.fIDToProxiesMap.remove(id);
                    ((IREMBeanProxy)proxy).release();
                    if (ref != null) {
                        ref.enqueue();
                    }
                }
            } else {
                ((IREMBeanProxy)proxy).release();
            }
        }
    }

    private void releaseID(int anID) {
        try {
            IREMConnection connect = this.fRegistry.getFreeConnection();
            try {
                connect.releaseID(anID);
            }
            finally {
                this.fRegistry.returnConnection(connect);
            }
        }
        catch (IllegalStateException illegalStateException) {}
    }

    IBeanProxy createBeanProxy(IREMBeanTypeProxy aTypeProxy) throws ThrowableProxy {
        return REMStandardBeanProxyConstants.getConstants(this.fRegistry).getClassNewInstance().invoke(null, aTypeProxy);
    }

    IBeanProxy createBeanProxy(IREMBeanTypeProxy aTypeProxy, String initializationString) throws ThrowableProxy, CommandException, ClassCastException, InstantiationException, IllegalStateException {
        IREMConnection connect = this.fRegistry.getFreeConnection();
        this.startTransaction();
        try {
            Commands.ValueObject newInstanceData;
            block21: {
                newInstanceData = null;
                try {
                    try {
                        newInstanceData = this.getNewInstanceData(aTypeProxy, initializationString, connect);
                    }
                    catch (CommandErrorException e) {
                        switch (e.getErrorCode()) {
                            case 4: {
                                throw new ClassCastException(MessageFormat.format(ProxyRemoteMessages.Classcast_EXC_, this.extractFirstLine(initializationString), aTypeProxy.getTypeName()));
                            }
                            case 3: {
                                StringWriter s = new StringWriter();
                                PrintWriter w = new PrintWriter(s);
                                ((ThrowableProxy)e.getErrorObject()).printProxyStackTrace(w);
                                ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, s.toString(), null));
                                throw new InstantiationException(MessageFormat.format(ProxyRemoteMessages.Instantiate_EXC_, this.extractFirstLine(initializationString)));
                            }
                        }
                        throw e;
                    }
                    catch (CommandException e) {
                        if (e.isRecoverable()) {
                            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
                        } else {
                            this.fRegistry.closeConnection(connect);
                            connect = null;
                            connect = this.fRegistry.getFreeConnection();
                            try {
                                newInstanceData = this.getNewInstanceData(aTypeProxy, initializationString, connect);
                            }
                            catch (CommandException commandException) {
                                this.fRegistry.closeConnection(connect);
                                connect = null;
                            }
                        }
                        if (connect != null) {
                            this.fRegistry.returnConnection(connect);
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    if (connect != null) {
                        this.fRegistry.returnConnection(connect);
                    }
                    throw throwable;
                }
                if (connect != null) {
                    this.fRegistry.returnConnection(connect);
                }
            }
            if (newInstanceData != null) {
                IBeanProxy iBeanProxy = this.getBeanProxy(newInstanceData);
                return iBeanProxy;
            }
        }
        finally {
            this.stopTransaction();
        }
        return null;
    }

    private String extractFirstLine(String initString) {
        int cr = initString.indexOf(13);
        int lf = initString.indexOf(10);
        if (cr != -1 || lf != -1) {
            if (cr == -1 || lf != -1 && lf < cr) {
                return initString.substring(0, lf);
            }
            return initString.substring(0, cr);
        }
        return initString;
    }

    private Commands.ValueObject getNewInstanceData(IREMBeanTypeProxy aTypeProxy, String initializationString, IREMConnection connect) throws ThrowableProxy, CommandException {
        try {
            Commands.ValueObject newInstanceData = new Commands.ValueObject();
            connect.getNewInstance(aTypeProxy.getID(), initializationString, newInstanceData);
            return newInstanceData;
        }
        catch (CommandErrorException e) {
            this.processErrorReturn(e);
            return null;
        }
    }

    private void getObjectInstanceData(IREMConnection connect, int objectID, Commands.ValueObject valueReturn) throws ThrowableProxy, CommandException {
        try {
            connect.getObjectData(objectID, valueReturn);
        }
        catch (CommandErrorException e) {
            this.processErrorReturn(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IBeanProxy getBeanProxy(Commands.ValueObject value) throws ThrowableProxy, CommandException {
        switch (value.type) {
            case 0: {
                return null;
            }
            case 23: {
                IREMConstantBeanTypeProxy constantBeanType = null;
                try {
                    constantBeanType = (IREMConstantBeanTypeProxy)((Object)this.getBeanType(value.classID));
                    if (constantBeanType != null) return constantBeanType.newBeanProxy(value);
                    return null;
                }
                catch (ClassCastException e) {
                    ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
                    return null;
                }
            }
            case 50: {
                Integer objectID = new Integer(value.objectID);
                IBeanProxy proxy = this.retrieveProxy(objectID, true);
                if (proxy != null) {
                    return proxy;
                }
                IREMConnection connect = this.fRegistry.getFreeConnection();
                try {
                    this.getObjectInstanceData(connect, value.objectID, value);
                }
                catch (CommandErrorException e) {
                    if (e.isRecoverable()) {
                        ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
                        if (connect == null) return null;
                        this.fRegistry.returnConnection(connect);
                        return null;
                    }
                    try {
                        this.fRegistry.closeConnection(connect);
                        connect = null;
                        connect = this.fRegistry.getFreeConnection();
                        try {
                            this.getObjectInstanceData(connect, value.objectID, value);
                            return this.getBeanProxy(value);
                        }
                        catch (CommandErrorException eAgain) {
                            this.fRegistry.closeConnection(connect);
                            connect = null;
                            throw eAgain;
                        }
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (connect != null) {
                            this.fRegistry.returnConnection(connect);
                        }
                    }
                }
                if (connect == null) return this.getBeanProxy(value);
                this.fRegistry.returnConnection(connect);
                return this.getBeanProxy(value);
            }
            case 51: {
                try {
                    IREMBeanTypeProxy newBeanType = this.getBeanType(value.classID);
                    IREMBeanProxy newProxy = newBeanType.newBeanProxy(new Integer(value.objectID));
                    if (newProxy == null) return newProxy;
                    this.registerProxy(newProxy);
                    return newProxy;
                }
                catch (CommandException e) {
                    this.releaseID(value.objectID);
                    throw e;
                }
                catch (RuntimeException e) {
                    this.releaseID(value.objectID);
                    throw e;
                }
            }
            case 52: {
                IREMBeanProxy newThrowProxy = null;
                try {
                    IREMBeanTypeProxy newThrowType = this.getBeanType(value.classID);
                    newThrowProxy = newThrowType.newBeanProxy(new Integer(value.objectID));
                    if (newThrowProxy != null) {
                        this.registerProxy(newThrowProxy);
                    }
                }
                catch (CommandException e) {
                    this.releaseID(value.objectID);
                    throw e;
                }
                catch (RuntimeException e) {
                    this.releaseID(value.objectID);
                    throw e;
                }
                if (!(newThrowProxy instanceof ThrowableProxy)) return newThrowProxy;
                throw (ThrowableProxy)((Object)newThrowProxy);
            }
        }
        IREMConstantBeanTypeProxy standardBeanType = null;
        try {
            standardBeanType = (IREMConstantBeanTypeProxy)((Object)this.getBeanType(value.type));
            if (standardBeanType != null) return standardBeanType.newBeanProxy(value);
            return null;
        }
        catch (ClassCastException e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            return null;
        }
    }

    public void processErrorReturn(CommandErrorException e) throws CommandException, ThrowableProxy {
        int code = e.getErrorCode();
        IBeanProxy data = null;
        if (code == 6) {
            data = this.getBeanProxy(e.getValue());
        } else {
            try {
                data = this.getBeanProxy(e.getValue());
            }
            catch (ThrowableProxy t) {
                data = t;
            }
        }
        throw new CommandErrorException(MessageFormat.format(ProxyRemoteMessages.RemoteCmd_EXC_, new Integer(code)), code, e.getValue(), data);
    }

    public IREMBeanTypeProxy getBeanType(int id) throws CommandException {
        IREMBeanTypeProxy beanType = null;
        try {
            Integer classID = new Integer(id);
            beanType = (IREMBeanTypeProxy)this.retrieveProxy(classID, false);
            if (beanType == null) {
                beanType = this.fBeanTypeProxyFactory.createBeanTypeProxy(classID);
            }
            if (beanType == null) {
                return null;
            }
        }
        catch (ClassCastException e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
        }
        finally {
            if (beanType == null) {
                this.releaseID(id);
            }
        }
        return beanType;
    }

    @Override
    public IIntegerBeanProxy createBeanProxyWith(int aPrimitiveInteger) {
        return this.fBeanTypeProxyFactory.intType.createIntegerBeanProxy(aPrimitiveInteger);
    }

    @Override
    public INumberBeanProxy createBeanProxyWith(byte aPrimitiveByte) {
        return this.fBeanTypeProxyFactory.byteType.createByteBeanProxy(aPrimitiveByte);
    }

    @Override
    public ICharacterBeanProxy createBeanProxyWith(char aPrimitiveChar) {
        return this.fBeanTypeProxyFactory.charType.createCharacterBeanProxy(aPrimitiveChar);
    }

    @Override
    public INumberBeanProxy createBeanProxyWith(short aPrimitiveShort) {
        return this.fBeanTypeProxyFactory.shortType.createShortBeanProxy(aPrimitiveShort);
    }

    @Override
    public INumberBeanProxy createBeanProxyWith(long aPrimitiveLong) {
        return this.fBeanTypeProxyFactory.longType.createLongBeanProxy(aPrimitiveLong);
    }

    @Override
    public INumberBeanProxy createBeanProxyWith(double aPrimitiveDouble) {
        return this.fBeanTypeProxyFactory.doubleType.createDoubleBeanProxy(aPrimitiveDouble);
    }

    @Override
    public INumberBeanProxy createBeanProxyWith(float aPrimitiveFloat) {
        return this.fBeanTypeProxyFactory.floatType.createFloatBeanProxy(aPrimitiveFloat);
    }

    @Override
    public IBooleanBeanProxy createBeanProxyWith(Boolean aBoolean) {
        return this.fBeanTypeProxyFactory.booleanClass.createBooleanBeanProxy(aBoolean);
    }

    @Override
    public IIntegerBeanProxy createBeanProxyWith(Integer anInteger) {
        return this.fBeanTypeProxyFactory.integerClass.createIntegerBeanProxy(anInteger);
    }

    @Override
    public INumberBeanProxy createBeanProxyWith(Number aNumber) {
        REMAbstractNumberBeanTypeProxy type = (REMAbstractNumberBeanTypeProxy)this.fBeanTypeProxyFactory.getBeanTypeProxy(aNumber.getClass().getName());
        return type.createNumberBeanProxy(aNumber);
    }

    @Override
    public IStringBeanProxy createBeanProxyWith(String aString) {
        return this.fBeanTypeProxyFactory.stringClass.createStringBeanProxy(aString);
    }

    @Override
    public ICharacterBeanProxy createBeanProxyWith(Character aCharacter) {
        return this.fBeanTypeProxyFactory.characterClass.createCharacterBeanProxy(aCharacter);
    }

    @Override
    public IBooleanBeanProxy createBeanProxyWith(boolean aPrimitiveBoolean) {
        return this.fBeanTypeProxyFactory.booleanType.createBooleanBeanProxy(aPrimitiveBoolean);
    }

    @Override
    public IArrayBeanProxy createBeanProxyWith(IBeanTypeProxy type, int[] dimensions) throws ThrowableProxy {
        if (type.isArray()) {
            return ((REMArrayBeanTypeProxy)type).createBeanProxyWith(dimensions);
        }
        REMArrayBeanTypeProxy arrayType = (REMArrayBeanTypeProxy)this.fBeanTypeProxyFactory.getBeanTypeProxy(type.getTypeName(), dimensions.length);
        return arrayType.createBeanProxyWith(dimensions);
    }

    @Override
    public IArrayBeanProxy createBeanProxyWith(IBeanTypeProxy type, int dimension) throws ThrowableProxy {
        return this.createBeanProxyWith(type, new int[]{dimension});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IBeanProxy retrieveProxy(Integer objectID, boolean incrementUseCnt) {
        HashMap hashMap = this.fIDToProxiesMap;
        synchronized (hashMap) {
            ProxyRef ref = (ProxyRef)this.fIDToProxiesMap.get(objectID);
            if (ref == null) {
                return null;
            }
            Object bp = ref.get();
            if (ref.isEnqueued() || bp == null) {
                this.fIDToProxiesMap.remove(objectID);
                ref.clear();
                return null;
            }
            if (incrementUseCnt) {
                ref.incrUseCnt();
            }
            return (IBeanProxy)bp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTransaction() {
        HashMap hashMap = this.fIDToProxiesMap;
        synchronized (hashMap) {
            ++this.transactionLockCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inTransaction() {
        HashMap hashMap = this.fIDToProxiesMap;
        synchronized (hashMap) {
            return this.transactionLockCount != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTransaction() {
        HashMap hashMap = this.fIDToProxiesMap;
        synchronized (hashMap) {
            if (--this.transactionLockCount < 0) {
                this.transactionLockCount = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminateFactory(boolean wait) {
        HashMap hashMap = this.fIDToProxiesMap;
        synchronized (hashMap) {
            for (ProxyRef ref : this.fIDToProxiesMap.values()) {
                Object bp;
                if (ref == null || (bp = ref.get()) == null || ref.isEnqueued()) continue;
                ((IREMBeanProxy)bp).release();
            }
            this.fIDToProxiesMap.clear();
            this.queue = null;
        }
    }

    @Override
    public IExpression createExpression() {
        return new REMExpression(this.fRegistry);
    }

    @Override
    public IBeanProxy createBeanProxyFrom(String initializationString) throws ThrowableProxy, ClassCastException, InstantiationException {
        try {
            return this.createBeanProxy(this.fBeanTypeProxyFactory.voidType, initializationString);
        }
        catch (CommandException e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            return null;
        }
    }

    @Override
    public IBeanProxy convertToPrimitiveBeanProxy(IBeanProxy nonPrimitiveProxy) {
        if (nonPrimitiveProxy == null) {
            return null;
        }
        if (!nonPrimitiveProxy.isValid()) {
            return nonPrimitiveProxy;
        }
        IREMBeanTypeProxy type = (IREMBeanTypeProxy)nonPrimitiveProxy.getTypeProxy();
        switch (type.getID()) {
            case 2: {
                return this.createBeanProxyWith(((IBooleanBeanProxy)nonPrimitiveProxy).booleanValue());
            }
            case 6: {
                return this.createBeanProxyWith(((INumberBeanProxy)nonPrimitiveProxy).byteValue());
            }
            case 8: {
                return this.createBeanProxyWith(((ICharacterBeanProxy)nonPrimitiveProxy).charValue());
            }
            case 10: {
                return this.createBeanProxyWith(((INumberBeanProxy)nonPrimitiveProxy).doubleValue());
            }
            case 12: {
                return this.createBeanProxyWith(((INumberBeanProxy)nonPrimitiveProxy).floatValue());
            }
            case 4: {
                return this.createBeanProxyWith(((INumberBeanProxy)nonPrimitiveProxy).intValue());
            }
            case 16: {
                return this.createBeanProxyWith(((INumberBeanProxy)nonPrimitiveProxy).longValue());
            }
            case 14: {
                return this.createBeanProxyWith(((INumberBeanProxy)nonPrimitiveProxy).shortValue());
            }
        }
        return nonPrimitiveProxy;
    }

    @Override
    public IBeanProxy getIVMServerProxy() {
        return this.vmServerProxy;
    }

    private static class ProxyRef
    extends WeakReference {
        private Integer id;
        private int useCnt = 1;

        public ProxyRef(Integer anID, Object proxy, ReferenceQueue q) {
            super(proxy, q);
            this.id = anID;
        }

        public Integer getID() {
            return this.id;
        }

        @Override
        public void clear() {
            super.clear();
            this.id = null;
        }

        public synchronized void incrUseCnt() {
            ++this.useCnt;
        }

        public synchronized int decrUseCnt() {
            if (--this.useCnt < 0) {
                this.useCnt = 0;
            }
            return this.useCnt;
        }
    }
}

