/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.tutorial.features;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.impl.AbstractCreateConnectionFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class TutorialCreateEReferenceFeature
extends AbstractCreateConnectionFeature {
    public TutorialCreateEReferenceFeature(IFeatureProvider fp) {
        super(fp, "EReference", "Create EReference");
    }

    public boolean canCreate(ICreateConnectionContext context) {
        EClass source = this.getEClass(context.getSourceAnchor());
        EClass target = this.getEClass(context.getTargetAnchor());
        return source != null && target != null && source != target;
    }

    public boolean canStartConnection(ICreateConnectionContext context) {
        return this.getEClass(context.getSourceAnchor()) != null;
    }

    public Connection create(ICreateConnectionContext context) {
        Connection newConnection = null;
        EClass source = this.getEClass(context.getSourceAnchor());
        EClass target = this.getEClass(context.getTargetAnchor());
        if (source != null && target != null) {
            EReference eReference = this.createEReference(source, target);
            AddConnectionContext addContext = new AddConnectionContext(context.getSourceAnchor(), context.getTargetAnchor());
            addContext.setNewObject((Object)eReference);
            newConnection = (Connection)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
        }
        return newConnection;
    }

    private EClass getEClass(Anchor anchor) {
        Object obj;
        if (anchor != null && (obj = this.getBusinessObjectForPictogramElement((PictogramElement)anchor.getParent())) instanceof EClass) {
            return (EClass)obj;
        }
        return null;
    }

    private EReference createEReference(EClass source, EClass target) {
        EReference eReference = EcoreFactory.eINSTANCE.createEReference();
        eReference.setName("new EReference");
        eReference.setEType((EClassifier)target);
        eReference.setLowerBound(0);
        eReference.setUpperBound(1);
        source.getEStructuralFeatures().add((Object)eReference);
        return eReference;
    }
}

