/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.plan;

import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.services.SQLEditorService;
import org.eclipse.datatools.sqltools.editor.ui.core.SQLToolsUIFacade;
import org.eclipse.datatools.sqltools.launching.IExtendedLaunchSupport;
import org.eclipse.datatools.sqltools.plan.IPlanService;
import org.eclipse.datatools.sqltools.routineeditor.launching.LaunchHelper;
import org.eclipse.datatools.sqltools.routineeditor.ui.ProcEditorInput;
import org.eclipse.datatools.sqltools.routineeditor.ui.RoutineEditorUIActivator;
import org.eclipse.datatools.sqltools.routineeditor.ui.launching.SPLaunchShortcut;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.plan.ExplainSQLActionDelegate;
import org.eclipse.debug.core.ILaunchConfiguration;

public class ExplainRoutineActionDelegate
extends ExplainSQLActionDelegate {
    protected String _procSql;
    protected ILaunchConfiguration _config;
    IExtendedLaunchSupport _extendedLaunchSupport = null;

    public ExplainRoutineActionDelegate(SQLEditor targetEditor) {
        super(targetEditor);
    }

    public void run() {
        if (this.explainAsRoutineObject()) {
            final ProcEditorInput procEditorInput = (ProcEditorInput)this._sqlEditor.getEditorInput();
            try {
                Runnable getQPRunnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ExplainRoutineActionDelegate.this._config = SPLaunchShortcut.getLaunchConfiguration(procEditorInput.getProcIdentifier(), "run");
                            if (ExplainRoutineActionDelegate.this._config == null) {
                                return;
                            }
                            ExplainRoutineActionDelegate.this._procSql = LaunchHelper.constructDirectInvocationSQLString((ILaunchConfiguration)ExplainRoutineActionDelegate.this._config);
                            ExplainRoutineActionDelegate.this._conn = SQLToolsFacade.getConnectionService((DatabaseIdentifier)ExplainRoutineActionDelegate.this.getDatabaseIdentifier()).createConnection(ExplainRoutineActionDelegate.this.getDatabaseIdentifier(), true);
                            SQLEditorService s = SQLToolsFacade.getConfiguration(null, (DatabaseIdentifier)ExplainRoutineActionDelegate.this.getDatabaseIdentifier()).getSQLEditorService();
                            ExplainRoutineActionDelegate.this._extendedLaunchSupport = s.getExtendedLaunchSupport();
                            if (ExplainRoutineActionDelegate.this._extendedLaunchSupport != null) {
                                ExplainRoutineActionDelegate.this._extendedLaunchSupport.preLaunch(ExplainRoutineActionDelegate.this._config, ExplainRoutineActionDelegate.this._conn, "run");
                            }
                            RoutineEditorUIActivator.getStandardDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ExplainRoutineActionDelegate.this.runDelegate();
                                }
                            });
                        }
                        catch (Exception exception) {}
                    }
                };
                Thread th = new Thread(getQPRunnable);
                th.start();
            }
            catch (Exception exception) {}
        } else {
            super.run();
        }
    }

    private void runDelegate() {
        super.run();
    }

    public String getSQLStatements() {
        if (this.explainAsRoutineObject()) {
            return this._procSql;
        }
        return super.getSQLStatements();
    }

    protected boolean explainAsRoutineObject() {
        return this.isRoutineEditor() && (this._sqlEditor.getSelectedText() == null || this._sqlEditor.getSelectedText().trim().equals(""));
    }

    protected boolean isRoutineEditor() {
        return this._sqlEditor != null && this._sqlEditor.getEditorInput() instanceof ProcEditorInput;
    }

    protected boolean isSelectionEmpty() {
        return this._sqlEditor == null || this._sqlEditor.getSelectedText() == null || this._sqlEditor.getSelectedText().trim().equals("");
    }

    public void update() {
        if (this.isRoutineEditor()) {
            ProcEditorInput procEditorInput = (ProcEditorInput)this._sqlEditor.getEditorInput();
            int procType = procEditorInput.getProcIdentifier().getType();
            IPlanService service = SQLToolsUIFacade.getPlanService((DatabaseIdentifier)this.getDatabaseIdentifier());
            boolean supported = false;
            if (service != null) {
                boolean bl = supported = service.getPlanOption() == null ? false : service.getPlanOption().supportPlan(procType);
            }
            if (!supported) {
                if (this.isSelectionEmpty()) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(this._sqlEditor != null && this._sqlEditor.getConnectionInfo().getSharedConnection() != null && super.canBeEnabled());
                }
            }
        } else {
            this.setEnabled(this._sqlEditor != null && this._sqlEditor.isConnected() && super.canBeEnabled());
        }
    }
}

