/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.editors.automake;

import java.util.ArrayList;
import org.eclipse.cdt.internal.autotools.ui.MakeUIImages;
import org.eclipse.cdt.internal.autotools.ui.editors.LexicalSortingAction;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.AutomakeConfigMacro;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.AutomakeEditor;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.AutomakeEditorFactory;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.AutomakeIfElse;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.IAutomakeConditional;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.NullMakefile;
import org.eclipse.cdt.make.core.makefile.IBadDirective;
import org.eclipse.cdt.make.core.makefile.ICommand;
import org.eclipse.cdt.make.core.makefile.IComment;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.core.makefile.IEmptyLine;
import org.eclipse.cdt.make.core.makefile.IInferenceRule;
import org.eclipse.cdt.make.core.makefile.IMacroDefinition;
import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.core.makefile.IParent;
import org.eclipse.cdt.make.core.makefile.IRule;
import org.eclipse.cdt.make.core.makefile.ITargetRule;
import org.eclipse.cdt.make.core.makefile.gnu.IInclude;
import org.eclipse.cdt.make.core.makefile.gnu.ITerminal;
import org.eclipse.cdt.make.ui.IWorkingCopyManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class AutomakefileContentOutlinePage
extends ContentOutlinePage {
    protected IMakefile makefile;
    protected IMakefile nullMakefile = new NullMakefile();
    private LexicalSortingAction sortAction;
    protected AutomakeEditor fEditor;
    protected Object fInput;

    public AutomakefileContentOutlinePage(AutomakeEditor editor) {
        this.fEditor = editor;
    }

    public void setInput(Object input) {
        this.fInput = input;
        this.update();
    }

    public void update() {
        Control control;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            control.getDisplay().asyncExec(() -> {
                if (!control.isDisposed()) {
                    control.setRedraw(false);
                    viewer.setInput(this.fInput);
                    viewer.expandAll();
                    control.setRedraw(true);
                }
            });
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new AutomakefileContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new AutomakefileLabelProvider());
        if (this.fInput != null) {
            viewer.setInput(this.fInput);
        }
        this.sortAction.setTreeViewer(viewer);
    }

    public void inputChanged(Object oldInput, Object newInput) {
        if (oldInput != null) {
            this.makefile = this.nullMakefile;
        }
        if (newInput != null) {
            IWorkingCopyManager manager = AutomakeEditorFactory.getDefault().getWorkingCopyManager();
            this.makefile = manager.getWorkingCopy((IEditorInput)newInput);
            if (this.makefile == null) {
                this.makefile = this.nullMakefile;
            }
        }
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        IToolBarManager toolBarManager = pageSite.getActionBars().getToolBarManager();
        this.sortAction = new LexicalSortingAction();
        toolBarManager.add((IAction)this.sortAction);
    }

    private class AutomakefileContentProvider
    implements ITreeContentProvider {
        protected boolean showMacroDefinition = true;
        protected boolean showTargetRule = true;
        protected boolean showInferenceRule = true;
        protected boolean showIncludeChildren = false;
        protected IMakefile makefile;
        protected IMakefile nullMakefile = new NullMakefile();

        private AutomakefileContentProvider() {
        }

        public Object[] getChildren(Object element) {
            if (element == AutomakefileContentOutlinePage.this.fInput) {
                return this.getElements(this.makefile);
            }
            if (element instanceof IDirective) {
                return this.getElements(element);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IMakefile) {
                return AutomakefileContentOutlinePage.this.fInput;
            }
            if (element instanceof IDirective) {
                return ((IDirective)element).getParent();
            }
            return AutomakefileContentOutlinePage.this.fInput;
        }

        public boolean hasChildren(Object element) {
            if (element == AutomakefileContentOutlinePage.this.fInput) {
                return true;
            }
            if (element instanceof IParent) {
                return !(element instanceof IInclude) || this.showIncludeChildren;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            Object[] directives = inputElement == AutomakefileContentOutlinePage.this.fInput ? this.makefile.getDirectives() : (inputElement instanceof IRule ? ((IRule)inputElement).getCommands() : (inputElement instanceof IParent ? (inputElement instanceof IInclude && !this.showIncludeChildren ? new IDirective[]{} : ((IParent)inputElement).getDirectives()) : new IDirective[]{}));
            ArrayList<IDirective> list = new ArrayList<IDirective>(directives.length);
            int i = 0;
            while (i < directives.length) {
                if (this.showMacroDefinition && directives[i] instanceof IMacroDefinition) {
                    list.add(directives[i]);
                } else if (this.showInferenceRule && directives[i] instanceof IInferenceRule) {
                    list.add(directives[i]);
                } else if (this.showTargetRule && directives[i] instanceof ITargetRule) {
                    list.add(directives[i]);
                } else if (this.showTargetRule && directives[i] instanceof AutomakeIfElse) {
                    list.add(directives[i]);
                } else {
                    boolean irrelevant;
                    boolean bl = irrelevant = directives[i] instanceof IComment || directives[i] instanceof IEmptyLine || directives[i] instanceof ITerminal;
                    if (!irrelevant) {
                        list.add(directives[i]);
                    }
                }
                ++i;
            }
            return list.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (oldInput != null) {
                this.makefile = this.nullMakefile;
            }
            if (newInput != null) {
                IWorkingCopyManager manager = AutomakeEditorFactory.getDefault().getWorkingCopyManager();
                this.makefile = manager.getWorkingCopy((IEditorInput)newInput);
                if (this.makefile == null) {
                    this.makefile = this.nullMakefile;
                }
            }
        }
    }

    private static class AutomakefileLabelProvider
    extends LabelProvider {
        private AutomakefileLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof ITargetRule) {
                return MakeUIImages.getImage(MakeUIImages.IMG_OBJS_MAKEFILE_TARGET_RULE);
            }
            if (element instanceof IInferenceRule) {
                return MakeUIImages.getImage(MakeUIImages.IMG_OBJS_MAKEFILE_INFERENCE_RULE);
            }
            if (element instanceof IMacroDefinition) {
                return MakeUIImages.getImage(MakeUIImages.IMG_OBJS_MAKEFILE_MACRO);
            }
            if (element instanceof IAutomakeConditional) {
                return super.getImage(element);
            }
            if (element instanceof ICommand) {
                return MakeUIImages.getImage(MakeUIImages.IMG_OBJS_MAKEFILE_COMMAND);
            }
            if (element instanceof IInclude) {
                return MakeUIImages.getImage(MakeUIImages.IMG_OBJS_MAKEFILE_INCLUDE);
            }
            if (element instanceof IBadDirective) {
                return MakeUIImages.getImage(MakeUIImages.IMG_OBJS_ERROR);
            }
            if (element instanceof AutomakeConfigMacro) {
                return MakeUIImages.getImage(MakeUIImages.IMG_OBJS_MAKEFILE_ACMACRO);
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            Object name;
            if (element instanceof IRule) {
                name = ((IRule)element).getTarget().toString().trim();
            } else if (element instanceof IMacroDefinition) {
                name = ((IMacroDefinition)element).getName().trim();
            } else if (element instanceof AutomakeIfElse) {
                AutomakeIfElse ifelse = (AutomakeIfElse)element;
                name = ifelse.getType().equals("if") ? "if " + ifelse.getCondition() : "else";
            } else if (element instanceof AutomakeConfigMacro) {
                AutomakeConfigMacro macro = (AutomakeConfigMacro)element;
                name = macro.getName();
            } else {
                name = super.getText(element);
            }
            if (name != null && ((String)(name = ((String)name).trim())).length() > 25) {
                name = ((String)name).substring(0, 25) + " ...";
            }
            return name;
        }
    }
}

