/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.ui.Logger;
import org.eclipse.php.internal.server.ui.ServerTypeCompositeFragment;
import org.eclipse.php.internal.ui.wizards.CompositeWizardFragment;
import org.eclipse.php.internal.ui.wizards.IControlHandler;
import org.eclipse.php.internal.ui.wizards.IWizardHandle;
import org.eclipse.php.internal.ui.wizards.WizardControlWrapper;
import org.eclipse.php.server.core.types.IServerType;
import org.eclipse.swt.widgets.Composite;

public class ServerTypeWizardFragment
extends CompositeWizardFragment {
    private ServerTypeCompositeFragment comp;

    public Composite createComposite(Composite parent, IWizardHandle wizard) {
        this.comp = new ServerTypeCompositeFragment(parent, (IControlHandler)new WizardControlWrapper(wizard), false);
        return this.comp;
    }

    public void enter() {
        if (this.comp != null) {
            try {
                Server server = new Server();
                this.comp.setData(server);
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        } else {
            Logger.log(4, "Could not display the Servers wizard (component is null).");
        }
    }

    public void exit() {
        if (this.comp != null) {
            this.comp.performApply();
            this.getWizardModel().putObject("server", this.comp.getData());
        }
    }

    public Composite getComposite() {
        return this.comp;
    }

    public boolean isComplete() {
        if (this.comp == null) {
            return super.isComplete();
        }
        return super.isComplete() && this.comp.isComplete();
    }

    public boolean performFinish(IProgressMonitor monitor) throws CoreException {
        boolean result = super.performFinish(monitor);
        if (this.comp != null) {
            result = this.comp.performOk();
        }
        return result;
    }

    public IServerType getType() {
        return this.comp != null ? this.comp.getType() : null;
    }
}

