/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.util.List;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeModel;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeLibrary;
import org.w3c.dom.Attr;
import org.w3c.dom.TypeInfo;

public class AttrType
extends NodeType {
    private static final String ATTRIBUTE = "attribute";
    Attr _value;

    public AttrType() {
        this(null, null);
    }

    public AttrType(Attr v, TypeModel tm) {
        super(v, tm);
        this._value = v;
    }

    @Override
    public String string_type() {
        return ATTRIBUTE;
    }

    @Override
    public String getStringValue() {
        return this._value.getValue();
    }

    @Override
    public ResultSequence typed_value() {
        TypeDefinition typeDef = this.getType();
        if (typeDef != null) {
            List types = typeDef.getSimpleTypes(this._value);
            return this.getXDMTypedValue(typeDef, types);
        }
        return new XSUntypedAtomic(this.getStringValue());
    }

    @Override
    public QName node_name() {
        QName name = new QName(this._value.getPrefix(), this._value.getLocalName(), this._value.getNamespaceURI());
        return name;
    }

    @Override
    public boolean isID() {
        return this.isAttrType("ID");
    }

    @Override
    public boolean isIDREF() {
        return this.isAttrType("IDREF");
    }

    protected boolean isAttrType(String typeName) {
        if (this._value.getOwnerDocument().isSupported("Core", "3.0")) {
            return this.typeInfo(typeName);
        }
        return false;
    }

    private boolean typeInfo(String typeName) {
        TypeInfo typeInfo = this._value.getSchemaTypeInfo();
        return this.isType(typeInfo, typeName);
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_UNTYPEDATOMIC;
    }
}

