/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.palette.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.gef.ui.palette.PaletteMessages;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;

public abstract class PaletteEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener {
    public static final String XML_NAME = "entry";
    private static final Border TOOLTIP_BORDER = new MarginBorder(0, 2, 1, 0);
    private static ImageCache globalImageCache;
    private AccessibleEditPart acc;
    private final PropertyChangeListener childListener = evt -> {
        if (evt.getPropertyName().equals("Visible")) {
            this.refreshChildren();
        }
    };
    private Image image;
    private ImageDescriptor imgDescriptor;

    public PaletteEditPart(PaletteEntry model) {
        this.setModel(model);
    }

    @Override
    public void activate() {
        super.activate();
        PaletteEntry model = this.getModel();
        model.addPropertyChangeListener(this);
        this.traverseChildren(model, true);
    }

    protected AccessibleEditPart createAccessible() {
        return null;
    }

    @Override
    public void createEditPolicies() {
    }

    protected IFigure createToolTip() {
        String message = this.getToolTipText();
        if (message == null || message.length() == 0) {
            return null;
        }
        FlowPage fp = new FlowPage(){

            public Dimension getPreferredSize(int w, int h) {
                Dimension d = super.getPreferredSize(-1, -1);
                if (d.width > 150) {
                    d = super.getPreferredSize(150, -1);
                }
                return d;
            }
        };
        fp.setOpaque(true);
        fp.setBorder(TOOLTIP_BORDER);
        TextFlow tf = new TextFlow();
        tf.setText(message);
        fp.add((IFigure)tf);
        return fp;
    }

    @Override
    public void deactivate() {
        PaletteEntry model = this.getModel();
        model.removePropertyChangeListener(this);
        this.traverseChildren(model, false);
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        super.deactivate();
    }

    @Override
    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.acc == null) {
            this.acc = this.createAccessible();
        }
        return this.acc;
    }

    public List<? extends PaletteEditPart> getChildren() {
        return super.getChildren();
    }

    @Override
    public DragTracker getDragTracker(Request request) {
        return new SingleSelectionTracker();
    }

    protected static ImageCache getImageCache() {
        ImageCache cache = globalImageCache;
        if (cache == null) {
            globalImageCache = cache = new ImageCache();
            Display display = Display.getDefault();
            if (display != null) {
                display.disposeExec(() -> {
                    if (globalImageCache != null) {
                        globalImageCache.dispose();
                        globalImageCache = null;
                    }
                });
            }
        }
        return cache;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<PaletteEntry> getModelChildren() {
        void palCont;
        PaletteEntry paletteEntry = this.getModel();
        if (!(paletteEntry instanceof PaletteContainer)) {
            return Collections.emptyList();
        }
        PaletteContainer paletteContainer = (PaletteContainer)paletteEntry;
        PaletteContainer cfr_ignored_0 = (PaletteContainer)paletteEntry;
        ArrayList<PaletteEntry> modelChildren = new ArrayList<PaletteEntry>(palCont.getChildren());
        PaletteEntry prevVisibleEntry = null;
        Iterator iter = modelChildren.iterator();
        while (iter.hasNext()) {
            PaletteEntry entry = (PaletteEntry)iter.next();
            if (!entry.isVisible()) {
                iter.remove();
                continue;
            }
            if (entry instanceof PaletteSeparator && prevVisibleEntry == null) {
                iter.remove();
                continue;
            }
            if (entry instanceof PaletteSeparator && prevVisibleEntry instanceof PaletteSeparator) {
                iter.remove();
                continue;
            }
            prevVisibleEntry = entry;
        }
        if (prevVisibleEntry instanceof PaletteSeparator) {
            modelChildren.remove(prevVisibleEntry);
        }
        return modelChildren;
    }

    @Override
    public PaletteEntry getModel() {
        return (PaletteEntry)super.getModel();
    }

    @Deprecated
    protected PaletteEntry getPaletteEntry() {
        return this.getModel();
    }

    protected PaletteViewer getPaletteViewer() {
        return (PaletteViewer)this.getViewer();
    }

    protected PaletteViewerPreferences getPreferenceSource() {
        return ((PaletteViewer)this.getViewer()).getPaletteViewerPreferences();
    }

    protected IFigure getToolTipFigure() {
        return this.getFigure();
    }

    protected String getToolTipText() {
        Object text = null;
        PaletteEntry entry = this.getModel();
        String desc = entry.getDescription();
        boolean needName = this.nameNeededInToolTip();
        if (desc == null || desc.trim().equals(entry.getLabel()) || desc.trim().equals("")) {
            if (needName) {
                text = entry.getLabel();
            }
        } else {
            text = needName ? entry.getLabel() + " " + PaletteMessages.NAME_DESCRIPTION_SEPARATOR + " " + desc : desc;
        }
        if (text != null && ((String)text).trim().equals("")) {
            return null;
        }
        return text;
    }

    protected boolean nameNeededInToolTip() {
        return this.getLayoutSetting() == 2;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if (property.equals("Children Changed")) {
            this.traverseChildren((List)evt.getOldValue(), false);
            this.refreshChildren();
            this.traverseChildren((List)evt.getNewValue(), true);
        } else if (property.equals("Name") || property.equals("Small Icon") || property.equals("Large Icon") || property.equals("Description")) {
            this.refreshVisuals();
        }
    }

    public void restoreState(IMemento memento) {
        IMemento[] childMementos = memento.getChildren(XML_NAME);
        int index = 0;
        for (PaletteEditPart paletteEditPart : this.getChildren()) {
            paletteEditPart.restoreState(childMementos[index]);
            ++index;
        }
    }

    public void saveState(IMemento memento) {
        this.getChildren().forEach(part -> part.saveState(memento.createChild(XML_NAME)));
    }

    protected void setImageDescriptor(ImageDescriptor desc) {
        if (desc == this.imgDescriptor) {
            return;
        }
        this.imgDescriptor = desc;
        this.setImageInFigure(PaletteEditPart.getImageCache().getImage(this.imgDescriptor));
    }

    protected void setImageInFigure(Image image) {
    }

    /*
     * WARNING - void declaration
     */
    private void traverseChildren(PaletteEntry parent, boolean add) {
        void container;
        PaletteEntry paletteEntry = parent;
        if (!(paletteEntry instanceof PaletteContainer)) {
            return;
        }
        PaletteContainer paletteContainer = (PaletteContainer)paletteEntry;
        PaletteContainer cfr_ignored_0 = (PaletteContainer)paletteEntry;
        this.traverseChildren(container.getChildren(), add);
    }

    private void traverseChildren(List<? extends PaletteEntry> children, boolean add) {
        for (PaletteEntry paletteEntry : children) {
            if (add) {
                paletteEntry.addPropertyChangeListener(this.childListener);
                continue;
            }
            paletteEntry.removePropertyChangeListener(this.childListener);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected int getLayoutSetting() {
        EditPart editPart = this.getParent();
        if (editPart instanceof PaletteEditPart) {
            void palEP;
            PaletteEditPart paletteEditPart = (PaletteEditPart)editPart;
            PaletteEditPart cfr_ignored_0 = (PaletteEditPart)editPart;
            return palEP.getLayoutSetting();
        }
        return this.getPreferenceSource().getLayoutSetting();
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isToolbarItem() {
        EditPart editPart = this.getParent();
        if (editPart instanceof PaletteEditPart) {
            void palEP;
            PaletteEditPart paletteEditPart = (PaletteEditPart)editPart;
            PaletteEditPart cfr_ignored_0 = (PaletteEditPart)editPart;
            return palEP.isToolbarItem();
        }
        return false;
    }

    protected static class ImageCache {
        private final Map<ImageDescriptor, Image> images = new HashMap<ImageDescriptor, Image>(11);

        protected ImageCache() {
        }

        Image getImage(ImageDescriptor desc) {
            if (desc == null) {
                return null;
            }
            return this.images.computeIfAbsent(desc, ImageDescriptor::createImage);
        }

        Image getMissingImage() {
            return this.getImage(ImageDescriptor.getMissingImageDescriptor());
        }

        void dispose() {
            this.images.values().forEach(Resource::dispose);
            this.images.clear();
        }
    }

    public class SingleSelectionTracker
    extends SelectEditPartTracker {
        public SingleSelectionTracker() {
            super(PaletteEditPart.this);
        }

        @Override
        protected void performSelection() {
            if (this.hasSelectionOccurred()) {
                return;
            }
            this.setFlag(64, true);
            this.getCurrentViewer().select(this.getSourceEditPart());
        }
    }
}

