/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Map;
import org.immutables.value.Value;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.EndpointSpec;
import org.mandas.docker.client.messages.swarm.ImmutableServiceSpec;
import org.mandas.docker.client.messages.swarm.NetworkAttachmentConfig;
import org.mandas.docker.client.messages.swarm.ServiceMode;
import org.mandas.docker.client.messages.swarm.TaskSpec;
import org.mandas.docker.client.messages.swarm.UpdateConfig;

@JsonDeserialize(builder=ImmutableServiceSpec.Builder.class)
@Value.Immutable
public interface ServiceSpec {
    @JsonProperty(value="Name")
    @Nullable
    public String name();

    @JsonProperty(value="Labels")
    @Nullable
    public Map<String, String> labels();

    @JsonProperty(value="TaskTemplate")
    public TaskSpec taskTemplate();

    @JsonProperty(value="Mode")
    @Nullable
    public ServiceMode mode();

    @JsonProperty(value="UpdateConfig")
    @Nullable
    public UpdateConfig updateConfig();

    @JsonProperty(value="Networks")
    @Nullable
    public List<NetworkAttachmentConfig> networks();

    @JsonProperty(value="EndpointSpec")
    @Nullable
    public EndpointSpec endpointSpec();

    public static Builder builder() {
        return ImmutableServiceSpec.builder();
    }

    public static interface Builder {
        public Builder name(String var1);

        public Builder addLabel(String var1, String var2);

        public Builder labels(Map<String, ? extends String> var1);

        public Builder taskTemplate(TaskSpec var1);

        public Builder mode(ServiceMode var1);

        public Builder updateConfig(UpdateConfig var1);

        public Builder networks(NetworkAttachmentConfig ... var1);

        public Builder networks(Iterable<? extends NetworkAttachmentConfig> var1);

        public Builder endpointSpec(EndpointSpec var1);

        public ServiceSpec build();
    }
}

