/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.update;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.update.ElementFormatEvent;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.update.ElementFormatUpdateTester;
import org.eclipse.cdt.dsf.ui.viewmodel.update.ICacheEntry;
import org.eclipse.cdt.dsf.ui.viewmodel.update.IElementUpdateTester;
import org.eclipse.cdt.dsf.ui.viewmodel.update.IElementUpdateTesterExtension;
import org.eclipse.cdt.dsf.ui.viewmodel.update.IVMUpdatePolicyExtension;
import org.eclipse.cdt.dsf.ui.viewmodel.update.ManualUpdatePolicy;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TreePath;

public class DebugManualUpdatePolicy
extends ManualUpdatePolicy
implements IVMUpdatePolicyExtension {
    private final Set<String> fActiveNumberFormatPropertiesWithPrefixes;
    private final Set<String> fElementFormatPropertiesWithPrefixes;
    private static final Set<String> ACTIVE_NUMBER_FORMAT_PROPERTIES = new TreeSet<String>();
    private static final Set<String> ELEMENT_FORMAT_PROPERTIES;
    private IElementUpdateTester fNumberFormatPropertyEventUpdateTester = new IElementUpdateTesterExtension(){

        @Override
        public int getUpdateFlags(Object viewerInput, TreePath path) {
            return 8;
        }

        @Override
        public Collection<String> getPropertiesToFlush(Object viewerInput, TreePath path, boolean isDirty) {
            return DebugManualUpdatePolicy.this.fActiveNumberFormatPropertiesWithPrefixes;
        }

        @Override
        public boolean includes(IElementUpdateTester tester) {
            return tester.equals(this);
        }

        public String toString() {
            return "Manual (refresh = false) update tester for an event that did not originate from the data model";
        }
    };

    static {
        ACTIVE_NUMBER_FORMAT_PROPERTIES.add("formatted_value_active_format");
        ACTIVE_NUMBER_FORMAT_PROPERTIES.add("formatted_value_active_format_value");
        ACTIVE_NUMBER_FORMAT_PROPERTIES.add("CurrentNumericStyle");
        ELEMENT_FORMAT_PROPERTIES = new TreeSet<String>();
        ELEMENT_FORMAT_PROPERTIES.add("formatted_value_active_format");
        ELEMENT_FORMAT_PROPERTIES.add("formatted_value_active_format_value");
    }

    public DebugManualUpdatePolicy() {
        this(new String[0]);
    }

    public DebugManualUpdatePolicy(String[] prefixes) {
        if (prefixes.length == 0) {
            this.fActiveNumberFormatPropertiesWithPrefixes = ACTIVE_NUMBER_FORMAT_PROPERTIES;
            this.fElementFormatPropertiesWithPrefixes = ELEMENT_FORMAT_PROPERTIES;
        } else {
            this.fActiveNumberFormatPropertiesWithPrefixes = new TreeSet<String>(ACTIVE_NUMBER_FORMAT_PROPERTIES);
            this.fElementFormatPropertiesWithPrefixes = new TreeSet<String>(ELEMENT_FORMAT_PROPERTIES);
            String[] stringArray = prefixes;
            int n = prefixes.length;
            int n2 = 0;
            while (n2 < n) {
                String prefix = stringArray[n2];
                this.fActiveNumberFormatPropertiesWithPrefixes.add((String.valueOf(prefix) + "formatted_value_active_format").intern());
                this.fActiveNumberFormatPropertiesWithPrefixes.add((String.valueOf(prefix) + "formatted_value_active_format_value").intern());
                this.fElementFormatPropertiesWithPrefixes.add((String.valueOf(prefix) + "formatted_value_active_format").intern());
                this.fElementFormatPropertiesWithPrefixes.add((String.valueOf(prefix) + "formatted_value_active_format_value").intern());
                ++n2;
            }
        }
    }

    @Override
    public IElementUpdateTester getElementUpdateTester(Object event) {
        if (event instanceof PropertyChangeEvent && "CurrentNumericStyle".equals(((PropertyChangeEvent)event).getProperty())) {
            return this.fNumberFormatPropertyEventUpdateTester;
        }
        if (event instanceof ElementFormatEvent) {
            return new ElementFormatUpdateTester((ElementFormatEvent)event, this.fElementFormatPropertiesWithPrefixes);
        }
        return super.getElementUpdateTester(event);
    }

    @Override
    public boolean canUpdateDirtyProperty(ICacheEntry entry, String property) {
        return this.fActiveNumberFormatPropertiesWithPrefixes.contains(property);
    }
}

