/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.internal.dnd;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Geometry;
import org.eclipse.papyrus.infra.core.sasheditor.Activator;
import org.eclipse.papyrus.infra.core.sasheditor.internal.dnd.IDragOverListener;
import org.eclipse.papyrus.infra.core.sasheditor.internal.dnd.IDropTarget;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class DragManager {
    private static final String DROP_TARGET_ID = "org.eclipse.ui.internal.dnd.dropTarget";
    private static DragManager instance;
    private List<IDragOverListener> defaultTargets = new ArrayList<IDragOverListener>();

    private DragManager() {
    }

    public static DragManager getInstance() {
        if (instance == null) {
            instance = new DragManager();
        }
        return instance;
    }

    public void addDragTarget(Control control, IDragOverListener target) {
        if (control == null) {
            this.defaultTargets.add(target);
        } else {
            List<IDragOverListener> targetList = this.getTargetList(control);
            if (targetList == null) {
                targetList = new ArrayList<IDragOverListener>(1);
            }
            targetList.add(target);
            control.setData(DROP_TARGET_ID, targetList);
        }
    }

    private List<IDragOverListener> getTargetList(Control control) {
        return (List)control.getData(DROP_TARGET_ID);
    }

    public void removeDragTarget(Control control, IDragOverListener target) {
        if (control == null) {
            this.defaultTargets.remove(target);
        } else {
            List<IDragOverListener> targetList = this.getTargetList(control);
            if (targetList != null) {
                targetList.remove(target);
                if (targetList.isEmpty()) {
                    control.setData(DROP_TARGET_ID, null);
                }
            }
        }
    }

    public boolean performDrag(Object draggedItem, Rectangle sourceBounds, Point initialLocation, boolean allowSnapping) {
        IDropTarget target = this.dragToTarget(draggedItem, sourceBounds, initialLocation, allowSnapping);
        if (target == null) {
            return false;
        }
        target.drop();
        return true;
    }

    private IDropTarget dragToTarget(Object draggedItem, Rectangle sourceBounds, Point initialLocation, boolean allowSnapping) {
        Shell shell;
        Display display = Display.getCurrent();
        Tracker tracker = new Tracker(display, 0);
        tracker.setStippled(true);
        tracker.addListener(10, event -> display.syncExec(() -> {
            Point location = new Point(event.x, event.y);
            IDropTarget target = null;
            Control targetControl = display.getCursorControl();
            target = this.getDropTarget(targetControl, draggedItem, location, tracker.getRectangles()[0]);
            Rectangle snapTarget = null;
            if (target != null) {
                snapTarget = target.getSnapRectangle();
                tracker.setCursor(target.getCursor());
            } else {
                tracker.setCursor(this.getInvalidDragCursor());
            }
            if (allowSnapping) {
                Rectangle[] currentRectangles;
                if (snapTarget == null) {
                    snapTarget = new Rectangle(rectangle.x + location.x - point.x, rectangle.y + location.y - point.y, rectangle.width, rectangle.height);
                }
                if ((currentRectangles = tracker.getRectangles()).length != 1 || !currentRectangles[0].equals((Object)snapTarget)) {
                    tracker.setRectangles(new Rectangle[]{Geometry.copy((Rectangle)snapTarget)});
                }
            }
        }));
        IDropTarget target = null;
        Control startControl = display.getCursorControl();
        if (startControl != null && allowSnapping) {
            target = this.getDropTarget(startControl, draggedItem, initialLocation, sourceBounds);
        }
        Rectangle startRect = sourceBounds;
        if (target != null) {
            Rectangle rect = target.getSnapRectangle();
            if (rect != null) {
                startRect = rect;
            }
            tracker.setCursor(target.getCursor());
        }
        if (startRect != null) {
            tracker.setRectangles(new Rectangle[]{Geometry.copy((Rectangle)startRect)});
        }
        if ((shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()) != null) {
            shell.setCapture(true);
        }
        boolean trackingOk = tracker.open();
        if (shell != null) {
            shell.setCapture(false);
        }
        IDropTarget dropTarget = null;
        Point finalLocation = display.getCursorLocation();
        Control targetControl = display.getCursorControl();
        dropTarget = this.getDropTarget(targetControl, draggedItem, finalLocation, tracker.getRectangles()[0]);
        tracker.dispose();
        if (trackingOk) {
            return dropTarget;
        }
        return null;
    }

    private IDropTarget getDropTarget(List<IDragOverListener> toSearch, Control mostSpecificControl, Object draggedObject, Point position, Rectangle dragRectangle) {
        if (toSearch == null) {
            return null;
        }
        for (IDragOverListener next : toSearch) {
            IDropTarget dropTarget = next.drag(mostSpecificControl, draggedObject, position, dragRectangle);
            if (dropTarget == null) continue;
            return dropTarget;
        }
        return null;
    }

    public IDropTarget getDropTarget(Control toSearch, Object draggedObject, Point position, Rectangle dragRectangle) {
        Control current = toSearch;
        while (current != null) {
            IDropTarget dropTarget = this.getDropTarget(this.getTargetList(current), toSearch, draggedObject, position, dragRectangle);
            if (dropTarget != null) {
                return dropTarget;
            }
            if (current instanceof Shell) break;
            current = current.getParent();
        }
        return this.getDropTarget(this.defaultTargets, toSearch, draggedObject, position, dragRectangle);
    }

    public Cursor getInvalidDragCursor() {
        return DragCursors.getCursor(0);
    }

    public Cursor getDragCursor(int swtPositionConstant) {
        return DragCursors.getCursor(DragCursors.positionToDragCursor(swtPositionConstant));
    }

    private static class DragCursors {
        public static final int INVALID = 0;
        public static final int LEFT = 1;
        public static final int RIGHT = 2;
        public static final int TOP = 3;
        public static final int BOTTOM = 4;
        public static final int CENTER = 5;
        public static final int OFFSCREEN = 6;
        public static final int FASTVIEW = 7;
        public static final Cursor[] cursors = new Cursor[8];

        private DragCursors() {
        }

        public static Cursor getCursor(int code) {
            Display display = Display.getCurrent();
            if (cursors[code] == null) {
                int imageSize = 16;
                ISharedImages sharedImages = DragCursors.getSharedImages();
                ImageData sourceImage = null;
                ImageData maskImage = null;
                switch (code) {
                    case 1: {
                        sourceImage = DragCursors.getImageDate("IMG_OBJS_DND_LEFT_SOURCE", sharedImages);
                        maskImage = DragCursors.getImageDate("IMG_OBJS_DND_LEFT_MASK", sharedImages);
                        break;
                    }
                    case 2: {
                        sourceImage = DragCursors.getImageDate("IMG_OBJS_DND_RIGHT_SOURCE", sharedImages);
                        maskImage = DragCursors.getImageDate("IMG_OBJS_DND_RIGHT_MASK", sharedImages);
                        break;
                    }
                    case 3: {
                        sourceImage = DragCursors.getImageDate("IMG_OBJS_DND_TOP_SOURCE", sharedImages);
                        maskImage = DragCursors.getImageDate("IMG_OBJS_DND_TOP_MASK", sharedImages);
                        break;
                    }
                    case 4: {
                        sourceImage = DragCursors.getImageDate("IMG_OBJS_DND_BOTTOM_SOURCE", sharedImages);
                        maskImage = DragCursors.getImageDate("IMG_OBJS_DND_BOTTOM_MASK", sharedImages);
                        break;
                    }
                    case 5: {
                        sourceImage = DragCursors.getImageDate("IMG_OBJS_DND_STACK_SOURCE", sharedImages);
                        maskImage = DragCursors.getImageDate("IMG_OBJS_DND_STACK_MASK", sharedImages);
                        break;
                    }
                    case 6: {
                        sourceImage = DragCursors.getImageDate("IMG_OBJS_DND_OFFSCREEN_SOURCE", sharedImages);
                        maskImage = DragCursors.getImageDate("IMG_OBJS_DND_OFFSCREEN_MASK", sharedImages);
                        break;
                    }
                    case 7: {
                        sourceImage = DragCursors.getImageDate("IMG_OBJS_DND_TOFASTVIEW_SOURCE", sharedImages);
                        maskImage = DragCursors.getImageDate("IMG_OBJS_DND_TOFASTVIEW_MASK", sharedImages);
                        break;
                    }
                    default: {
                        sourceImage = DragCursors.getImageDate("IMG_OBJS_DND_INVALID_SOURCE", sharedImages);
                        maskImage = DragCursors.getImageDate("IMG_OBJS_DND_INVALID_MASK", sharedImages);
                    }
                }
                if (sourceImage == null) {
                    Activator.log.warn("The source image of the drag cursor is null");
                    return null;
                }
                if (maskImage == null) {
                    Activator.log.warn("The mask image of the drag cursor is null");
                    DragCursors.cursors[code] = new Cursor((Device)display, sourceImage, imageSize, imageSize);
                } else {
                    DragCursors.cursors[code] = new Cursor((Device)display, sourceImage, maskImage, imageSize, imageSize);
                }
            }
            return cursors[code];
        }

        public static int positionToDragCursor(int swtPositionConstant) {
            switch (swtPositionConstant) {
                case 16384: {
                    return 1;
                }
                case 131072: {
                    return 2;
                }
                case 128: {
                    return 3;
                }
                case 1024: {
                    return 4;
                }
                case 0x1000000: {
                    return 5;
                }
            }
            return 0;
        }

        private static ISharedImages getSharedImages() {
            if (PlatformUI.getWorkbench() != null) {
                return PlatformUI.getWorkbench().getSharedImages();
            }
            return null;
        }

        private static ImageData getImageDate(String symbolicName, ISharedImages sharedImages) {
            ImageDescriptor descriptor;
            int zoom = 100;
            if (sharedImages != null && (descriptor = sharedImages.getImageDescriptor(symbolicName)) != null) {
                return descriptor.getImageData(zoom);
            }
            return null;
        }
    }
}

