/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IField;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Conversions;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Cost;
import org.eclipse.cdt.internal.ui.text.contentassist.PositionBasedCompletionProposal;
import org.eclipse.cdt.internal.ui.viewsupport.CElementImageProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;

public class ParameterGuesser {
    private final Set<String> fAlreadyMatchedNames = new HashSet<String>();

    private Collection<Variable> evaluateVisibleMatches(IType expectedType, List<IBinding> suggestions) throws CModelException {
        HashSet<Variable> res = new HashSet<Variable>();
        int size = suggestions.size();
        int i = 0;
        while (i < size) {
            Variable variable = this.createVariable(suggestions.get(i), expectedType, i);
            if (variable != null) {
                if (this.fAlreadyMatchedNames.contains(variable.name)) {
                    variable.alreadyMatched = true;
                }
                res.add(variable);
            }
            ++i;
        }
        return res;
    }

    private boolean isAnonymousBinding(IBinding binding) {
        char[] name = binding.getNameCharArray();
        return name.length == 0 || name[0] == '{';
    }

    protected IType getType(IBinding binding) {
        if (!this.isAnonymousBinding(binding) && binding instanceof IVariable) {
            return ((IVariable)binding).getType();
        }
        return null;
    }

    private Variable createVariable(IBinding element, IType enclosingType, int positionScore) throws CModelException {
        IType elementType = this.getType(element);
        String elementName = element.getName();
        if (elementType != null && enclosingType != null && (elementType.toString().equals(enclosingType.toString()) || elementType.isSameType(enclosingType) || this.isImplicitlyConvertible(enclosingType, elementType) || this.isParent(elementType, enclosingType) || this.isReferenceTo(enclosingType, elementType) || this.isReferenceTo(elementType, enclosingType))) {
            VariableType variableType = VariableType.GLOBAL;
            if (element instanceof ICPPField) {
                variableType = VariableType.FIELD;
            } else if (element instanceof IVariable) {
                try {
                    variableType = element instanceof ICPPBinding && ((ICPPBinding)element).isGloballyQualified() ? VariableType.GLOBAL : VariableType.LOCAL;
                }
                catch (DOMException dOMException) {
                    // empty catch block
                }
            }
            if (this.isReferenceTo(enclosingType, elementType)) {
                elementName = "&" + elementName;
            } else if (this.isReferenceTo(elementType, enclosingType)) {
                elementName = "*" + elementName;
            }
            return new Variable(elementName, variableType, positionScore, CharArrayUtils.EMPTY_CHAR_ARRAY, this.getImageDescriptor(element));
        }
        return null;
    }

    private boolean isReferenceTo(IType ref, IType val) {
        IType ptr;
        return ref instanceof IPointerType && ((ptr = ((IPointerType)ref).getType()).toString().equals(val.toString()) || ptr.isSameType(val));
    }

    private boolean isImplicitlyConvertible(IType orginType, IType candidateType) {
        try {
            Cost cost = Conversions.checkImplicitConversionSequence((IType)orginType, (IType)candidateType, (IASTExpression.ValueCategory)IASTExpression.ValueCategory.LVALUE, (Conversions.UDCMode)Conversions.UDCMode.ALLOWED, (Conversions.Context)Conversions.Context.ORDINARY);
            return cost.converts();
        }
        catch (DOMException e) {
            return false;
        }
    }

    private boolean isParent(IType child, IType parent) {
        if (child != null && parent != null && child instanceof ICPPClassType && !(child instanceof ICPPClassSpecialization) && parent instanceof ICPPClassType && !(parent instanceof ICPPClassSpecialization)) {
            ICPPBase[] bases;
            ICPPBase[] iCPPBaseArray = bases = ((ICPPClassType)child).getBases();
            int n = bases.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPBase base = iCPPBaseArray[n2];
                IType tmpType = base.getBaseClassType();
                if (tmpType.toString().equals(parent.toString()) || tmpType.isSameType(parent) || this.isParent(tmpType, parent)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private ImageDescriptor getImageDescriptor(IBinding binding) {
        IBinding[] delegates;
        ImageDescriptor imageDescriptor = null;
        if (binding instanceof ITypedef) {
            imageDescriptor = CElementImageProvider.getTypedefImageDescriptor();
        } else if (binding instanceof ICompositeType) {
            if (((ICompositeType)binding).getKey() == 3 || binding instanceof ICPPClassTemplate) {
                imageDescriptor = CElementImageProvider.getClassImageDescriptor();
            } else if (((ICompositeType)binding).getKey() == 1) {
                imageDescriptor = CElementImageProvider.getStructImageDescriptor();
            } else if (((ICompositeType)binding).getKey() == 2) {
                imageDescriptor = CElementImageProvider.getUnionImageDescriptor();
            }
        } else if (binding instanceof ICPPMethod) {
            switch (((ICPPMethod)binding).getVisibility()) {
                case 3: {
                    imageDescriptor = CElementImageProvider.getMethodImageDescriptor(ASTAccessVisibility.PRIVATE);
                    break;
                }
                case 2: {
                    imageDescriptor = CElementImageProvider.getMethodImageDescriptor(ASTAccessVisibility.PROTECTED);
                    break;
                }
                default: {
                    imageDescriptor = CElementImageProvider.getMethodImageDescriptor(ASTAccessVisibility.PUBLIC);
                    break;
                }
            }
        } else if (binding instanceof IFunction) {
            imageDescriptor = CElementImageProvider.getFunctionImageDescriptor();
        } else if (binding instanceof ICPPField) {
            switch (((ICPPField)binding).getVisibility()) {
                case 3: {
                    imageDescriptor = CElementImageProvider.getFieldImageDescriptor(ASTAccessVisibility.PRIVATE);
                    break;
                }
                case 2: {
                    imageDescriptor = CElementImageProvider.getFieldImageDescriptor(ASTAccessVisibility.PROTECTED);
                    break;
                }
                default: {
                    imageDescriptor = CElementImageProvider.getFieldImageDescriptor(ASTAccessVisibility.PUBLIC);
                    break;
                }
            }
        } else if (binding instanceof IField) {
            imageDescriptor = CElementImageProvider.getFieldImageDescriptor(ASTAccessVisibility.PUBLIC);
        } else if (binding instanceof IVariable) {
            imageDescriptor = CElementImageProvider.getVariableImageDescriptor();
        } else if (binding instanceof IEnumeration) {
            imageDescriptor = CElementImageProvider.getEnumerationImageDescriptor();
        } else if (binding instanceof IEnumerator) {
            imageDescriptor = CElementImageProvider.getEnumeratorImageDescriptor();
        } else if (binding instanceof ICPPNamespace) {
            imageDescriptor = CElementImageProvider.getNamespaceImageDescriptor();
        } else if (binding instanceof ICPPFunctionTemplate) {
            imageDescriptor = CElementImageProvider.getFunctionImageDescriptor();
        } else if (binding instanceof ICPPUsingDeclaration && (delegates = ((ICPPUsingDeclaration)binding).getDelegates()).length > 0) {
            return this.getImageDescriptor(delegates[0]);
        }
        return imageDescriptor;
    }

    public ICompletionProposal[] parameterProposals(IType expectedType, String paramName, Position pos, List<IBinding> suggestions, boolean isLastParameter) throws CModelException {
        ArrayList<Variable> typeMatches = new ArrayList<Variable>(this.evaluateVisibleMatches(expectedType, suggestions));
        ParameterGuesser.orderMatches(typeMatches, paramName);
        ICompletionProposal[] ret = new ICompletionProposal[typeMatches.size()];
        int i = 0;
        int replacementLength = 0;
        for (Variable v : typeMatches) {
            char[] triggers;
            if (i == 0) {
                this.fAlreadyMatchedNames.add(v.name);
                replacementLength = v.name.length();
            }
            String displayString = v.name;
            if (isLastParameter) {
                triggers = v.triggerChars;
            } else {
                triggers = new char[v.triggerChars.length + 1];
                System.arraycopy(v.triggerChars, 0, triggers, 0, v.triggerChars.length);
                triggers[triggers.length - 1] = 44;
            }
            ret[i++] = new PositionBasedCompletionProposal(v.name, pos, replacementLength, ParameterGuesser.getImage(v.descriptor), displayString, null, null, triggers);
        }
        return ret;
    }

    private static void orderMatches(List<Variable> typeMatches, String paramName) {
        if (typeMatches != null) {
            ParameterGuesser.calculateVariablesScores(paramName, typeMatches);
            Collections.sort(typeMatches, new MatchComparator());
        }
    }

    private static void calculateVariablesScores(String parameterName, List<Variable> variables) {
        for (Variable v : variables) {
            v.totalScore = ParameterGuesser.score(v, parameterName);
        }
    }

    private static int score(Variable v, String parameterName) {
        int shorter;
        int variableScore = 100 - v.variableType.getPriority();
        int subStringScore = ParameterGuesser.getContainedString(v.name, parameterName).length();
        if ((double)subStringScore < 0.6 * (double)(shorter = Math.min(v.name.length(), parameterName.length()))) {
            subStringScore = 0;
        }
        int positionScore = v.positionScore;
        int matchedScore = v.alreadyMatched ? 0 : 1;
        int score = variableScore << 21 | subStringScore << 11 | matchedScore << 10 | positionScore;
        return score;
    }

    private static String getContainedString(String first, String second) {
        String longerStr;
        String shorterStr = first.length() < second.length() ? first : second;
        String string = longerStr = first == shorterStr ? second : first;
        if (longerStr.contains(shorterStr)) {
            return shorterStr;
        }
        return "";
    }

    private static Image getImage(ImageDescriptor descriptor) {
        return descriptor == null ? null : CUIPlugin.getImageDescriptorRegistry().get(descriptor);
    }

    private static class MatchComparator
    implements Comparator<Variable> {
        private MatchComparator() {
        }

        @Override
        public int compare(Variable one, Variable two) {
            return two.totalScore - one.totalScore;
        }
    }

    private static final class Variable {
        public final String name;
        public final VariableType variableType;
        public final int positionScore;
        public int totalScore;
        public final char[] triggerChars;
        public final ImageDescriptor descriptor;
        public boolean alreadyMatched;

        public Variable(String name, VariableType variableType, int positionScore, char[] triggerChars, ImageDescriptor descriptor) {
            this.name = name;
            this.variableType = variableType;
            this.positionScore = positionScore;
            this.triggerChars = triggerChars;
            this.descriptor = descriptor;
        }
    }

    static enum VariableType {
        LOCAL(0),
        FIELD(1),
        GLOBAL(3);

        private final int priority;

        private VariableType(int priority) {
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

