/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.internal.clipboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.clipboard.ICopierFactory;
import org.eclipse.papyrus.infra.core.internal.clipboard.DefaultConfigurator;

class CopierConfiguratorRegistry
implements ICopierFactory.Configurator {
    private static final String EXT_PT = "copier";
    static CopierConfiguratorRegistry INSTANCE = new CopierConfiguratorRegistry();
    private final Collection<ICopierFactory.Configurator> configurators = new Reader(Platform.getExtensionRegistry(), "org.eclipse.papyrus.infra.core", "copier").load();

    private CopierConfiguratorRegistry() {
    }

    @Override
    public void configureCopier(ICopierFactory.Configuration copierConfiguration) {
        this.configurators.forEach(c -> c.configureCopier(copierConfiguration));
    }

    private static class Reader
    extends RegistryReader {
        private static final String FACTORY_CONFIGURATION = "factoryConfiguration";
        private static final String CONFIGURATOR = "configurator";
        private Collection<ICopierFactory.Configurator> configurators;
        private ICopierFactory.Configurator currentConfigurator;
        private Predicate<IConfigurationElement> configurationReader;

        Reader(IExtensionRegistry pluginRegistry, String pluginID, String extensionPointID) {
            super(pluginRegistry, pluginID, extensionPointID);
        }

        Collection<ICopierFactory.Configurator> load() {
            ArrayList<ICopierFactory.Configurator> result = new ArrayList<ICopierFactory.Configurator>();
            this.configurators = result;
            try {
                this.readRegistry();
            }
            finally {
                this.configurators = null;
            }
            return result;
        }

        protected boolean readElement(IConfigurationElement element) {
            boolean result = false;
            if (FACTORY_CONFIGURATION.equals(element.getName())) {
                result = true;
                if (element.getAttribute(CONFIGURATOR) != null) {
                    this.currentConfigurator = new ConfiguratorDescriptor(element);
                    this.configurationReader = null;
                } else {
                    DefaultConfigurator configurator = new DefaultConfigurator();
                    this.currentConfigurator = configurator;
                    this.configurationReader = configurator::readElement;
                }
                this.configurators.add(this.currentConfigurator);
            } else if (this.currentConfigurator != null) {
                result = this.configurationReader != null ? this.configurationReader.test(element) : true;
            }
            return result;
        }

        private class ConfiguratorDescriptor
        extends RegistryReader.PluginClassDescriptor
        implements ICopierFactory.Configurator {
            private Optional<ICopierFactory.Configurator> resolved;

            ConfiguratorDescriptor(IConfigurationElement element) {
                super(element, Reader.CONFIGURATOR);
            }

            @Override
            public void configureCopier(ICopierFactory.Configuration copierConfiguration) {
                this.resolve().ifPresent(c -> c.configureCopier(copierConfiguration));
            }

            Optional<ICopierFactory.Configurator> resolve() {
                if (this.resolved == null) {
                    ICopierFactory.Configurator delegate = null;
                    try {
                        delegate = (ICopierFactory.Configurator)this.createInstance();
                    }
                    catch (ClassCastException e) {
                        Activator.log.warn("Not an ICopierFactory.Configurator extension in " + this.element.getContributor().getName());
                    }
                    catch (WrappedException e) {
                        Activator.log.log(((CoreException)((Object)e.exception())).getStatus());
                    }
                    catch (Exception e) {
                        Activator.log.error("Unhandled exception creating copier factory configurator extension in " + this.element.getContributor().getName(), (Throwable)e);
                    }
                    this.resolved = Optional.ofNullable(delegate);
                }
                return this.resolved;
            }
        }
    }
}

