/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.core.internal.target;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.launchbar.core.internal.Activator;
import org.eclipse.launchbar.core.internal.target.LaunchTarget;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.ILaunchTargetListener;
import org.eclipse.launchbar.core.target.ILaunchTargetManager;
import org.eclipse.launchbar.core.target.ILaunchTargetManager2;
import org.eclipse.launchbar.core.target.ILaunchTargetProvider;
import org.eclipse.launchbar.core.target.TargetStatus;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class LaunchTargetManager
implements ILaunchTargetManager,
ILaunchTargetManager2 {
    private Map<String, Map<String, ILaunchTarget>> targets;
    private Map<String, IConfigurationElement> typeElements;
    private Map<String, ILaunchTargetProvider> typeProviders = new LinkedHashMap<String, ILaunchTargetProvider>();
    private List<ILaunchTargetListener> listeners = Collections.synchronizedList(new LinkedList());
    private static final String DELIMETER1 = ",";
    private static final String DELIMETER2 = ":";
    private static final String SLASH = "/";
    private static final String SLASH_REPLACER = ";";

    private Preferences getTargetsPref() {
        return InstanceScope.INSTANCE.getNode(Activator.getDefault().getBundle().getSymbolicName()).node(this.getClass().getSimpleName());
    }

    private synchronized void initTargets() {
        if (this.targets == null) {
            this.typeElements = new LinkedHashMap<String, IConfigurationElement>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint(String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + ".launchTargetTypes");
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    String id = element.getAttribute("id");
                    if (id != null) {
                        this.typeElements.put(id, element);
                    }
                    ++n4;
                }
                ++n2;
            }
            this.targets = new LinkedHashMap<String, Map<String, ILaunchTarget>>();
            Preferences prefs = this.getTargetsPref();
            try {
                String[] stringArray = prefs.childrenNames();
                int n5 = stringArray.length;
                n = 0;
                while (n < n5) {
                    String childName = stringArray[n];
                    String[] segments = childName.split(DELIMETER1);
                    if (segments.length == 2) {
                        String typeId = segments[0];
                        String name = segments[1].replaceAll(SLASH_REPLACER, SLASH);
                        Map<String, ILaunchTarget> type = this.targets.get(typeId);
                        if (type == null) {
                            type = new LinkedHashMap<String, ILaunchTarget>();
                            this.targets.put(typeId, type);
                        }
                        type.put(name, new LaunchTarget(typeId, name, prefs.node(childName)));
                    }
                    ++n;
                }
                if (prefs.keys().length > 0) {
                    stringArray = prefs.keys();
                    n5 = stringArray.length;
                    n = 0;
                    while (n < n5) {
                        String typeId = stringArray[n];
                        Map<String, ILaunchTarget> type = this.targets.get(typeId);
                        if (type == null) {
                            type = new LinkedHashMap<String, ILaunchTarget>();
                            this.targets.put(typeId, type);
                        }
                        String[] stringArray2 = prefs.get(typeId, "").split(DELIMETER1);
                        int n6 = stringArray2.length;
                        int n7 = 0;
                        while (n7 < n6) {
                            String name = stringArray2[n7];
                            if (!type.containsKey(name)) {
                                type.put(name, new LaunchTarget(typeId, name, prefs.node(String.valueOf(typeId) + DELIMETER1 + name)));
                            }
                            ++n7;
                        }
                        prefs.remove(typeId);
                        ++n;
                    }
                    prefs.flush();
                }
            }
            catch (BackingStoreException e) {
                Activator.log(e);
            }
            for (String typeId : this.typeElements.keySet()) {
                ILaunchTargetProvider provider = this.getProvider(typeId);
                if (provider == null) continue;
                provider.init(this);
            }
        }
    }

    private ILaunchTargetProvider getProvider(String typeId) {
        this.initTargets();
        ILaunchTargetProvider provider = this.typeProviders.get(typeId);
        if (provider == null) {
            IConfigurationElement element = this.typeElements.get(typeId);
            if (element != null) {
                try {
                    provider = (ILaunchTargetProvider)element.createExecutableExtension("provider");
                }
                catch (CoreException e) {
                    Activator.log(e);
                }
            }
            if (provider == null) {
                provider = new ILaunchTargetProvider(){

                    @Override
                    public void init(ILaunchTargetManager targetManager) {
                    }

                    @Override
                    public TargetStatus getStatus(ILaunchTarget target) {
                        return TargetStatus.OK_STATUS;
                    }
                };
            }
            this.typeProviders.put(typeId, provider);
        }
        return provider;
    }

    @Override
    public ILaunchTarget[] getLaunchTargets() {
        this.initTargets();
        ArrayList<ILaunchTarget> targetList = new ArrayList<ILaunchTarget>();
        for (Map<String, ILaunchTarget> type : this.targets.values()) {
            targetList.addAll(type.values());
        }
        return targetList.toArray(new ILaunchTarget[targetList.size()]);
    }

    @Override
    public ILaunchTarget[] getLaunchTargetsOfType(String typeId) {
        this.initTargets();
        Map<String, ILaunchTarget> type = this.targets.get(typeId);
        if (type != null) {
            return type.values().toArray(new ILaunchTarget[type.size()]);
        }
        return new ILaunchTarget[0];
    }

    @Override
    public ILaunchTarget getLaunchTarget(String typeId, String id) {
        this.initTargets();
        Map<String, ILaunchTarget> type = this.targets.get(typeId);
        if (type != null) {
            return type.get(id);
        }
        return null;
    }

    @Override
    public TargetStatus getStatus(ILaunchTarget target) {
        return this.getProvider(target.getTypeId()).getStatus(target);
    }

    @Override
    public ILaunchTarget addLaunchTargetNoNotify(String typeId, String id) {
        this.initTargets();
        Map<String, ILaunchTarget> type = this.targets.get(typeId);
        if (type == null) {
            type = new LinkedHashMap<String, ILaunchTarget>();
            this.targets.put(typeId, type);
        }
        try {
            Preferences child;
            Preferences prefs = this.getTargetsPref();
            String childName = String.valueOf(typeId) + DELIMETER1 + id.replaceAll(SLASH, SLASH_REPLACER);
            if (prefs.nodeExists(childName)) {
                child = prefs.node(childName);
            } else {
                child = prefs.node(childName);
                child.put("name", id);
            }
            LaunchTarget target = new LaunchTarget(typeId, id, child);
            type.put(id, target);
            prefs.flush();
            return target;
        }
        catch (BackingStoreException e) {
            Activator.log(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILaunchTarget addLaunchTarget(String typeId, String id) {
        ILaunchTarget target = this.addLaunchTargetNoNotify(typeId, id);
        if (target != null) {
            List<ILaunchTargetListener> list = this.listeners;
            synchronized (list) {
                for (ILaunchTargetListener listener : this.listeners) {
                    listener.launchTargetAdded(target);
                }
            }
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLaunchTarget(ILaunchTarget target) {
        this.initTargets();
        String typeId = target.getTypeId();
        Map<String, ILaunchTarget> type = this.targets.get(typeId);
        if (type != null) {
            type.remove(target.getId());
            if (type.isEmpty()) {
                this.targets.remove(target.getTypeId());
            }
            try {
                this.getTargetsPref().node(String.valueOf(typeId) + DELIMETER1 + target.getId().replaceAll(SLASH, SLASH_REPLACER)).removeNode();
            }
            catch (BackingStoreException e) {
                Activator.log(e);
            }
            List<ILaunchTargetListener> list = this.listeners;
            synchronized (list) {
                for (ILaunchTargetListener listener : this.listeners) {
                    listener.launchTargetRemoved(target);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void targetStatusChanged(ILaunchTarget target) {
        List<ILaunchTargetListener> list = this.listeners;
        synchronized (list) {
            for (ILaunchTargetListener listener : this.listeners) {
                listener.launchTargetStatusChanged(target);
            }
        }
    }

    @Override
    public ILaunchTarget getDefaultLaunchTarget(ILaunchConfiguration configuration) {
        Preferences prefs = this.getTargetsPref().node("configs");
        String targetId = prefs.get(configuration.getName(), null);
        if (targetId != null) {
            String[] parts = targetId.split(DELIMETER2);
            return this.getLaunchTarget(parts[0], parts[1]);
        }
        return null;
    }

    @Override
    public void setDefaultLaunchTarget(ILaunchConfiguration configuration, ILaunchTarget target) {
        Preferences prefs = this.getTargetsPref().node("configs");
        String targetId = String.join((CharSequence)DELIMETER2, target.getTypeId(), target.getId());
        prefs.put(configuration.getName(), targetId);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            Activator.log(e);
        }
    }

    @Override
    public void addListener(ILaunchTargetListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ILaunchTargetListener listener) {
        this.listeners.remove(listener);
    }
}

