/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.m2m.atl.engine.vm.ASM;
import org.eclipse.m2m.atl.engine.vm.ASMExecEnv;
import org.eclipse.m2m.atl.engine.vm.ASMInstruction;
import org.eclipse.m2m.atl.engine.vm.ASMInstructionWithOperand;
import org.eclipse.m2m.atl.engine.vm.ASMOperation;
import org.eclipse.m2m.atl.engine.vm.AtlVMMessages;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModule;

public class AtlSuperimposeModule {
    private ASMExecEnv env;
    private ASM asm;
    private boolean atl2006;

    public AtlSuperimposeModule(ASMExecEnv env, ASM asm) {
        this.env = env;
        this.asm = asm;
    }

    public void adaptModuleOperations() throws AtlSuperimposeModuleException {
        this.adaptMain();
        this.removeOperation("main");
        this.adaptOperation("__matcher__", 2);
        this.removeOperation("__matcher__");
        this.adaptOperation("__exec__", 10);
        this.removeOperation("__exec__");
    }

    private void adaptMain() throws AtlSuperimposeModuleException {
        ASMOperation origOp = (ASMOperation)this.env.getOperation(ASMModule.myType, "main");
        ASMOperation newOp = this.asm.getOperation("main");
        if (origOp != null && newOp != null) {
            this.mainSanityCrossCheck(origOp, newOp);
            if (this.atl2006) {
                this.insertHelperInits(newOp.getInstructions(), origOp.getInstructions());
                this.insertEntryPointRuleCall(newOp.getInstructions(), origOp.getInstructions());
                this.insertEndPointRuleCall(newOp.getInstructions(), origOp.getInstructions());
            } else {
                List origInit = this.getInstructions(origOp.getInstructions(), "call A.__init", 20, 1);
                List newInit = this.getInstructions(newOp.getInstructions(), "call A.__init", 20, 1);
                origOp.getInstructions().addAll(origInit.size() + 21, newInit);
            }
        }
    }

    private void mainSanityCrossCheck(ASMOperation main1, ASMOperation main2) throws AtlSuperimposeModuleException {
        this.mainSanityCheck(main1);
        this.mainSanityCheck(main2);
        int preEnd = 21;
        if (this.atl2006) {
            preEnd = 16;
        }
        int i = 0;
        while (i < preEnd) {
            String ins2;
            String ins1 = main1.getInstructions().get(i).toString();
            if (!ins1.equals(ins2 = main2.getInstructions().get(i).toString())) {
                throw new AtlSuperimposeModuleException(String.valueOf(AtlVMMessages.getString("AtlSuperimposeModule.0")) + ins1 + " != " + ins2 + " @ " + String.valueOf(i) + ")");
            }
            ++i;
        }
    }

    private void mainSanityCheck(ASMOperation main) throws AtlSuperimposeModuleException {
        if (main.getInstructions().size() < 21) {
            throw new AtlSuperimposeModuleException(String.valueOf(AtlVMMessages.getString("AtlSuperimposeModule.1")) + String.valueOf(main.getInstructions().size()) + AtlVMMessages.getString("AtlSuperimposeModule.2"));
        }
        String instr16 = main.getInstructions().get(15).toString();
        if (!instr16.equals("set col")) {
            throw new AtlSuperimposeModuleException(String.valueOf(AtlVMMessages.getString("AtlSuperimposeModule.3")) + instr16 + AtlVMMessages.getString("AtlSuperimposeModule.4"));
        }
        if (this.indexOfInstruction(main.getInstructions(), "set links", 16) == -1) {
            throw new AtlSuperimposeModuleException(AtlVMMessages.getString("AtlSuperimposeModule.5"));
        }
        String instr1 = main.getInstructions().get(0).toString();
        if (instr1.equals("getasm")) {
            this.atl2006 = true;
        }
    }

    private List getInstructions(List instr, String prefix, int start, int context) {
        ArrayList init = new ArrayList();
        int i = start + context;
        while (i < instr.size()) {
            ASMInstruction ins = (ASMInstruction)instr.get(i);
            if (ins.toString().startsWith(prefix)) {
                init.addAll(instr.subList(i - context, i + 1));
            }
            ++i;
        }
        return init;
    }

    private int indexOfInstruction(List instr, String prefix, int start) {
        int i = start;
        while (i < instr.size()) {
            ASMInstruction ins = (ASMInstruction)instr.get(i);
            if (ins.toString().startsWith(prefix)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void adaptOperation(String op, int patternLength) throws AtlSuperimposeModuleException {
        ASMOperation origOp = (ASMOperation)this.env.getOperation(ASMModule.myType, op);
        ASMOperation newOp = this.asm.getOperation(op);
        if (origOp != null && newOp != null) {
            this.sanityCrossCheck(origOp, newOp, patternLength);
            List newOpInstr = newOp.getInstructions();
            List origOpInstr = origOp.getInstructions();
            String origOpRun = AtlSuperimposeModule.serialise(origOpInstr, 0, origOpInstr.size());
            int i = 0;
            while (i < newOpInstr.size()) {
                String newOpRun = AtlSuperimposeModule.serialise(newOpInstr, i, patternLength);
                if (origOpRun.indexOf(newOpRun) == -1) {
                    int j = i;
                    while (j < Math.min(i + patternLength, newOpInstr.size())) {
                        origOp.addInstruction((ASMInstruction)newOpInstr.get(j));
                        ++j;
                    }
                }
                i += patternLength;
            }
        }
    }

    private void insertHelperInits(List from, List into) {
        int endOfInitCode = this.indexOfInstruction(from, "set links", 16) - 4;
        List initInstr = from.subList(16, endOfInitCode);
        int pos = this.indexOfInstruction(into, "set links", 16) - 4;
        this.transposeOffsets(into, initInstr.size(), pos);
        this.transposeOffsets(initInstr, pos - 16, 0);
        into.addAll(pos, initInstr);
    }

    private void insertEntryPointRuleCall(List from, List into) {
        if (this.includesEntryPointRule(from) && !this.includesEntryPointRule(into)) {
            int firstInstructionCode = this.indexOfInstruction(from, "set links", 16) + 2;
            List entryPointInstr = from.subList(firstInstructionCode, firstInstructionCode + 2);
            int pos = this.indexOfInstruction(into, "set links", 16) + 2;
            this.transposeOffsets(into, entryPointInstr.size(), pos);
            this.transposeOffsets(entryPointInstr, pos - 16, 0);
            into.addAll(pos, entryPointInstr);
        }
    }

    private void insertEndPointRuleCall(List from, List into) {
        if (this.includesEndPointRule(from) && !this.includesEndPointRule(into)) {
            int lastInstructionCode = this.indexOfInstruction(from, "call A.__exec__", 16) + 1;
            List endPointInstr = from.subList(lastInstructionCode, lastInstructionCode + 2);
            int pos = this.indexOfInstruction(into, "call A.__exec__", 16) + 1;
            this.transposeOffsets(into, endPointInstr.size(), pos);
            this.transposeOffsets(endPointInstr, pos - 16, 0);
            into.addAll(pos, endPointInstr);
        }
    }

    private boolean includesEntryPointRule(List instructions) {
        return this.indexOfInstruction(instructions, "call A.__matcher__", 16) - this.indexOfInstruction(instructions, "set links", 16) > 2;
    }

    private boolean includesEndPointRule(List instructions) {
        return instructions.size() - this.indexOfInstruction(instructions, "call A.__exec__", 16) > 1;
    }

    private void transposeOffsets(List instructions, int transpose, int start) {
        Iterator i = instructions.iterator();
        while (i.hasNext()) {
            int offset;
            ASMInstructionWithOperand instr;
            String mn;
            Object instruction = i.next();
            if (!(instruction instanceof ASMInstructionWithOperand) || !(mn = (instr = (ASMInstructionWithOperand)instruction).getMnemonic()).equals("if") && !mn.equals("goto") || (offset = Integer.parseInt(instr.getOperand())) < start) continue;
            instr.setOperand(String.valueOf(offset += transpose));
        }
    }

    private void sanityCrossCheck(ASMOperation op1, ASMOperation op2, int patternLength) throws AtlSuperimposeModuleException {
        this.sanityCheck(op1, patternLength);
        this.sanityCheck(op2, patternLength);
        List instr1 = op1.getInstructions();
        List instr2 = op2.getInstructions();
        int limit = Math.min(instr1.size(), instr2.size());
        limit = Math.min(limit, patternLength);
        int i = 0;
        while (i < limit) {
            String i2;
            String i1 = ((ASMInstruction)instr1.get(i)).getMnemonic();
            if (!i1.equals(i2 = ((ASMInstruction)instr2.get(i)).getMnemonic())) {
                throw new AtlSuperimposeModuleException(String.valueOf(AtlVMMessages.getString("AtlSuperimposeModule.6")) + op1.getName() + " (" + i1 + " != " + i2 + " @ " + String.valueOf(i) + ")");
            }
            ++i;
        }
    }

    private void sanityCheck(ASMOperation op, int patternLength) throws AtlSuperimposeModuleException {
        List instr = op.getInstructions();
        if (instr.size() % patternLength > 0) {
            throw new AtlSuperimposeModuleException(String.valueOf(AtlVMMessages.getString("AtlSuperimposeModule.7")) + String.valueOf(patternLength) + " for " + op.getName());
        }
        int i = 0;
        while (i < instr.size() - patternLength) {
            String i2;
            String i1 = ((ASMInstruction)instr.get(i)).getMnemonic();
            if (!i1.equals(i2 = ((ASMInstruction)instr.get(i + patternLength)).getMnemonic())) {
                throw new AtlSuperimposeModuleException(String.valueOf(AtlVMMessages.getString("AtlSuperimposeModule.8")) + String.valueOf(patternLength) + " instructions in " + op.getName() + " (" + i1 + " != " + i2 + " @ " + String.valueOf(i) + ")");
            }
            ++i;
        }
    }

    private static String serialise(List instrs, int start, int length) {
        StringBuffer ser = new StringBuffer();
        int i = Math.max(0, start);
        while (i < Math.min(instrs.size(), start + length)) {
            ser.append(instrs.get(i));
            ser.append(';');
            ++i;
        }
        return ser.toString();
    }

    private void removeOperation(String op) {
        ASMOperation asmOp = this.asm.getOperation(op);
        if (asmOp != null) {
            this.asm.getOperations().remove(asmOp);
        }
    }

    public class AtlSuperimposeModuleException
    extends Exception {
        static final long serialVersionUID = 20061201L;

        public AtlSuperimposeModuleException(String msg) {
            super(msg);
        }
    }
}

