/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.qt.core;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.cdt.build.gcc.core.GCCToolChain;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.core.build.IToolChainProvider;
import org.eclipse.cdt.core.envvar.EnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.internal.qt.core.Activator;
import org.eclipse.cdt.utils.WindowsRegistry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;

public class QtMinGWToolChainProvider
implements IToolChainProvider {
    public static final String ID = "org.eclipse.cdt.qt.core.qtMinGWProvider";
    public static final String TOOLCHAIN_ID = "qt.mingw";

    public String getId() {
        return ID;
    }

    public void init(IToolChainManager manager) throws CoreException {
        if (Platform.getOS().equals("win32")) {
            String subkey;
            WindowsRegistry registry = WindowsRegistry.getRegistry();
            String uninstallKey = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall";
            int i = 0;
            while ((subkey = registry.getCurrentUserKeyName(uninstallKey, i)) != null) {
                Path installLocation;
                String compKey = String.valueOf(uninstallKey) + '\\' + subkey;
                String displayName = registry.getCurrentUserValue(compKey, "DisplayName");
                if ("Qt".equals(displayName) && Files.exists(installLocation = Paths.get(registry.getCurrentUserValue(compKey, "InstallLocation"), new String[0]), new LinkOption[0])) {
                    Path gcc = Paths.get("bin\\gcc.exe", new String[0]);
                    try {
                        Files.walk(installLocation.resolve("Tools"), 1, new FileVisitOption[0]).filter(path2 -> Files.exists(path2.resolve(gcc), new LinkOption[0])).forEach(path2 -> {
                            IEnvironmentVariable[] env = new IEnvironmentVariable[]{new EnvironmentVariable("PATH", path2.resolve("bin").toString(), 3, File.pathSeparator)};
                            GCCToolChain toolChain = new GCCToolChain((IToolChainProvider)this, path2.resolve(gcc), "x86", env);
                            toolChain.setProperty("os", "win32");
                            toolChain.setProperty("package", "qt");
                            manager.addToolChain((IToolChain)toolChain);
                            if (Platform.getOSArch().equals("x86_64")) {
                                toolChain = new GCCToolChain((IToolChainProvider)this, path2.resolve(gcc), "x86_64", env);
                                toolChain.setProperty("os", "win32");
                                toolChain.setProperty("package", "qt");
                                manager.addToolChain((IToolChain)toolChain);
                            }
                        });
                    }
                    catch (IOException e) {
                        Activator.log(e);
                    }
                }
                ++i;
            }
        }
    }
}

