/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.jobs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ptp.core.jobs.IJobListener;
import org.eclipse.ptp.core.jobs.IJobStatus;

public class JobManager {
    private static final String ALL_JOBS = "ALL_JOBS";
    private static final JobManager fInstance = new JobManager();
    private final Map<String, IJobStatus> fJobs = Collections.synchronizedMap(new HashMap());
    private final Map<String, ListenerList> fJobListeners = Collections.synchronizedMap(new HashMap());

    public static JobManager getInstance() {
        return fInstance;
    }

    private JobManager() {
    }

    private void addJob(IJobStatus jobStatus) {
        this.fJobs.put(String.valueOf(jobStatus.getControlId()) + "+" + jobStatus.getJobId(), jobStatus);
    }

    public void addListener(IJobListener listener) {
        ListenerList listeners = this.fJobListeners.get(ALL_JOBS);
        if (listeners == null) {
            listeners = new ListenerList();
            this.fJobListeners.put(ALL_JOBS, listeners);
        }
        listeners.add((Object)listener);
    }

    public void addListener(String qualifier, IJobListener listener) {
        ListenerList listeners = this.fJobListeners.get(qualifier);
        if (listeners == null) {
            listeners = new ListenerList();
            this.fJobListeners.put(qualifier, listeners);
        }
        listeners.add((Object)listener);
    }

    private void cleanUpJobs() {
        ArrayList<String> completedJobs = new ArrayList<String>();
        for (IJobStatus job : this.fJobs.values()) {
            if (!job.getState().equals("COMPLETED")) continue;
            completedJobs.add(job.getJobId());
        }
        for (String jobId : completedJobs) {
            this.fJobs.remove(jobId);
        }
    }

    public void fireJobAdded(IJobStatus jobStatus) {
        Object listener;
        int n;
        int n2;
        Object[] objectArray;
        this.addJob(jobStatus);
        ListenerList listeners = this.fJobListeners.get(jobStatus.getControlId());
        if (listeners != null) {
            objectArray = listeners.getListeners();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                listener = objectArray[n];
                ((IJobListener)listener).jobAdded(jobStatus);
                ++n;
            }
        }
        if ((listeners = this.fJobListeners.get(ALL_JOBS)) != null) {
            objectArray = listeners.getListeners();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                listener = objectArray[n];
                ((IJobListener)listener).jobAdded(jobStatus);
                ++n;
            }
        }
    }

    public void fireJobChanged(IJobStatus jobStatus) {
        Object listener;
        int n;
        int n2;
        Object[] objectArray;
        ListenerList listeners = this.fJobListeners.get(jobStatus.getControlId());
        if (listeners != null) {
            objectArray = listeners.getListeners();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                listener = objectArray[n];
                ((IJobListener)listener).jobChanged(jobStatus);
                ++n;
            }
        }
        if ((listeners = this.fJobListeners.get(ALL_JOBS)) != null) {
            objectArray = listeners.getListeners();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                listener = objectArray[n];
                ((IJobListener)listener).jobChanged(jobStatus);
                ++n;
            }
        }
        this.cleanUpJobs();
    }

    public IJobStatus getJob(String controlId, String jobId) {
        return this.fJobs.get(String.valueOf(controlId) + "+" + jobId);
    }

    public IJobStatus[] getJobs() {
        return this.fJobs.values().toArray(new IJobStatus[0]);
    }

    public void removeListener(IJobListener listener) {
        for (ListenerList listeners : this.fJobListeners.values()) {
            listeners.remove((Object)listener);
        }
    }

    public void removeListener(String qualifier, IJobListener listener) {
        ListenerList listeners = this.fJobListeners.get(qualifier);
        if (listeners != null) {
            listeners.remove((Object)listener);
        }
    }
}

