/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.tagmodel;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.Namespace;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.ITagResolvingStrategy;
import org.eclipse.jst.jsf.facelet.core.internal.registry.IFaceletTagResolvingStrategy;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.IFaceletTagRecord;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.FaceletTaglibTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaceletNamespace
extends Namespace {
    private static final long serialVersionUID = 2133853120220947741L;
    private final FaceletNamespaceData _data;
    private boolean isInitialized;

    public FaceletNamespace(IFaceletTagRecord record, ITagResolvingStrategy<IFaceletTagResolvingStrategy.TLDWrapper, String> resolver) {
        this._data = new TaglibFaceletNamespaceData(record, resolver);
    }

    public String getDisplayName() {
        return this._data.getDisplayName();
    }

    public String getNSUri() {
        return this._data.getUri();
    }

    public Collection<? extends ITagElement> getViewElements() {
        Collection<ITagElement> values = this._data.getAllViewElements().values();
        this.isInitialized = true;
        return values;
    }

    public String toString() {
        return "Namespace: " + this.getNSUri() + "\n";
    }

    public ITagElement getViewElement(String name) {
        return this._data.getViewElement(name);
    }

    public boolean hasViewElements() {
        return this._data.getNumTags() > 0;
    }

    public boolean isInitialized() {
        return this.isInitialized || this._data.isInitialized();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class FaceletNamespaceData
    implements Serializable {
        private static final long serialVersionUID = 1697605990460247389L;

        public abstract String getDisplayName();

        public abstract int getNumTags();

        public abstract String getUri();

        public abstract ITagElement getViewElement(String var1);

        public abstract Map<String, ITagElement> getAllViewElements();

        public abstract boolean isInitialized();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaglibFaceletNamespaceData
    extends FaceletNamespaceData {
        private static final long serialVersionUID = -562720162853425804L;
        private final transient IFaceletTagRecord _record;
        private final transient ITagResolvingStrategy<IFaceletTagResolvingStrategy.TLDWrapper, String> _resolver;
        private final Map<String, ITagElement> _tags;

        public TaglibFaceletNamespaceData(IFaceletTagRecord record, ITagResolvingStrategy<IFaceletTagResolvingStrategy.TLDWrapper, String> resolver) {
            this._record = record;
            this._tags = new HashMap<String, ITagElement>();
            this._resolver = resolver;
        }

        @Override
        public synchronized Map<String, ITagElement> getAllViewElements() {
            if (!this.isInitialized()) {
                for (FaceletTaglibTag faceletTaglibTag : this._record.getTags()) {
                    this.getViewElement(faceletTaglibTag.getTagName());
                }
            }
            return this._tags;
        }

        @Override
        public synchronized ITagElement getViewElement(String name) {
            FaceletTaglibTag tagDefn = this._record.getTag(name);
            if (tagDefn != null) {
                return this.getAndInitIfMissing(tagDefn);
            }
            return null;
        }

        private ITagElement getAndInitIfMissing(FaceletTaglibTag tagDefn) {
            ITagElement tagElement = this._tags.get(tagDefn.getTagName());
            if (tagElement == null) {
                tagElement = this._resolver.resolve((Object)new IFaceletTagResolvingStrategy.TLDWrapper(tagDefn, this.getUri()));
                this._tags.put(tagDefn.getTagName(), tagElement);
            }
            return tagElement;
        }

        @Override
        public synchronized boolean isInitialized() {
            return this._tags.size() == this._record.getNumTags();
        }

        @Override
        public String getDisplayName() {
            return this._record.getURI();
        }

        @Override
        public int getNumTags() {
            return this._record.getNumTags();
        }

        @Override
        public String getUri() {
            return this._record.getURI();
        }
    }
}

