/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.actions;

import org.eclipse.cdt.debug.core.model.ISteppingModeTarget;
import org.eclipse.cdt.debug.core.model.ITargetProperties;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class DsfSteppingModeTarget
implements ISteppingModeTarget,
ITargetProperties {
    private static final String ID_DISASSEMBLY_VIEW = "org.eclipse.cdt.dsf.debug.ui.disassembly.view";
    private final Preferences fPreferences = new Preferences();

    public DsfSteppingModeTarget() {
        this.fPreferences.setDefault("instruction_stepping_mode", false);
    }

    public void enableInstructionStepping(boolean enabled) {
        this.fPreferences.setValue("instruction_stepping_mode", enabled);
        if (enabled) {
            try {
                IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (activeWorkbenchWindow != null && activeWorkbenchWindow.getActivePage() != null) {
                    activeWorkbenchWindow.getActivePage().showView(ID_DISASSEMBLY_VIEW);
                }
            }
            catch (PartInitException exc) {
                DsfUIPlugin.log(exc);
            }
        }
    }

    public boolean isInstructionSteppingEnabled() {
        return this.fPreferences.getBoolean("instruction_stepping_mode");
    }

    public boolean supportsInstructionStepping() {
        return true;
    }

    public void addPropertyChangeListener(Preferences.IPropertyChangeListener listener) {
        this.fPreferences.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(Preferences.IPropertyChangeListener listener) {
        this.fPreferences.removePropertyChangeListener(listener);
    }
}

