/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.extensions.jface;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.viatra.addon.viewers.runtime.ViatraViewerSupport;
import org.eclipse.viatra.addon.viewers.runtime.extensions.SelectionHelper;
import org.eclipse.viatra.addon.viewers.runtime.extensions.ViatraViewersViewSupport;
import org.eclipse.viatra.addon.viewers.runtime.extensions.ViewersComponentConfiguration;
import org.eclipse.viatra.addon.viewers.runtime.model.ViatraViewerDataModel;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerState;
import org.eclipse.viatra.query.runtime.api.IModelConnectorTypeEnum;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.emf.EMFScope;

public class ViatraViewersJFaceViewSupport
extends ViatraViewersViewSupport
implements ISelectionProvider {
    protected ContentViewer jfaceViewer;
    SelectionHelper selectionHelper = new SelectionHelper();

    public ViatraViewersJFaceViewSupport(IViewPart _owner, ViewersComponentConfiguration _config, IModelConnectorTypeEnum _scope, ContentViewer _jfaceViewer) {
        super(_owner, _config, _scope);
        this.jfaceViewer = _jfaceViewer;
    }

    @Override
    protected void init() {
        super.init();
        this.jfaceViewer.addSelectionChangedListener(this.selectionHelper.getTrickyListener());
    }

    @Override
    public void dispose() {
        if (this.jfaceViewer != null) {
            this.jfaceViewer.removeSelectionChangedListener(this.selectionHelper.getTrickyListener());
        }
        super.dispose();
    }

    @Override
    protected void bindModel() {
        ViatraQueryEngine engine;
        Assert.isNotNull((Object)this.configuration);
        Assert.isNotNull(this.configuration.getPatterns());
        if (this.state != null && !this.state.isDisposed()) {
            this.state.dispose();
        }
        if ((engine = this.getEngine()) != null) {
            this.configuration.setModel((EMFScope)engine.getScope());
            this.state = ViatraViewerDataModel.newViewerState(engine, this.configuration.getPatterns(), this.configuration.getFilter(), (Collection<ViewerState.ViewerStateFeature>)ImmutableSet.of((Object)((Object)ViewerState.ViewerStateFeature.EDGE), (Object)((Object)ViewerState.ViewerStateFeature.CONTAINMENT)));
            if (this.jfaceViewer instanceof AbstractListViewer) {
                ViatraViewerSupport.bind((AbstractListViewer)this.jfaceViewer, this.state);
            } else if (this.jfaceViewer instanceof AbstractTreeViewer) {
                ViatraViewerSupport.bind((AbstractTreeViewer)this.jfaceViewer, this.state);
            }
        }
    }

    @Override
    protected void unbindModel() {
        if (this.jfaceViewer != null && !this.jfaceViewer.getControl().isDisposed() && this.jfaceViewer.getInput() != null) {
            this.jfaceViewer.setInput(null);
        }
        if (this.state != null && !this.state.isDisposed()) {
            this.state.dispose();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionHelper.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.selectionHelper.unwrapElements_ViewersElementsToEObjects(this.jfaceViewer.getSelection());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionHelper.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.jfaceViewer.setSelection(this.selectionHelper.unwrapElements_EObjectsToViewersElements(selection, this.state));
    }

    @Override
    protected void onSelectionChanged(List<Object> objects) {
        super.onSelectionChanged(objects);
        this.setSelection((ISelection)new StructuredSelection(objects));
    }
}

