/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.tabbed;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.core.interfaces.IPropertyChangeProvider;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNodeProvider;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class BaseTitledSection
extends AbstractPropertySection
implements PropertyChangeListener {
    protected Section section;
    protected Composite composite;
    protected IPropertyChangeProvider viewerInput;
    protected IPeerNodeProvider provider;

    public void setInput(IWorkbenchPart part, ISelection selection) {
        IPeerNodeProvider provider;
        super.setInput(part, selection);
        if (this.viewerInput != null) {
            this.viewerInput.removePropertyChangeListener((PropertyChangeListener)this);
        }
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        IPeerNodeProvider iPeerNodeProvider = provider = input instanceof IPeerNodeProvider ? (IPeerNodeProvider)input : null;
        if (provider == null) {
            IPeerNodeProvider iPeerNodeProvider2 = provider = input instanceof IAdaptable ? (IPeerNodeProvider)((IAdaptable)input).getAdapter(IPeerNodeProvider.class) : null;
        }
        if (provider == null) {
            provider = (IPeerNodeProvider)Platform.getAdapterManager().getAdapter(input, IPeerNodeProvider.class);
        }
        if (provider != null) {
            this.provider = provider;
            IPeerNode peerNode = this.getPeerNode(provider);
            this.viewerInput = (IPropertyChangeProvider)peerNode.getAdapter(IPropertyChangeProvider.class);
            if (this.viewerInput != null) {
                this.viewerInput.addPropertyChangeListener((PropertyChangeListener)this);
            }
        } else {
            this.provider = null;
            this.viewerInput = null;
        }
        this.updateInput(provider);
    }

    protected IPeerNode getPeerNode(final IPeerNodeProvider provider) {
        Assert.isNotNull((Object)provider);
        final AtomicReference peerNode = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                peerNode.set(provider.getPeerNode());
            }
        });
        return (IPeerNode)peerNode.get();
    }

    protected void updateInput(IPeerNodeProvider input) {
    }

    public void aboutToBeHidden() {
        if (this.viewerInput != null) {
            this.viewerInput.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    protected int getStandardLabelWidth() {
        return 85;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        parent.setLayout((Layout)new FormLayout());
        this.section = this.getWidgetFactory().createSection(parent, 256);
        this.section.setText(this.getText());
        FormData data = new FormData();
        data.left = new FormAttachment(0, 6);
        data.right = new FormAttachment(100, -6);
        data.top = new FormAttachment(0, 8);
        this.section.setLayoutData((Object)data);
        this.composite = this.getWidgetFactory().createComposite(parent);
        FormLayout layout = new FormLayout();
        layout.spacing = 6;
        this.composite.setLayout((Layout)layout);
        data = new FormData();
        data.left = new FormAttachment(0, 12);
        data.right = new FormAttachment(100, -12);
        data.top = new FormAttachment((Control)this.section, 4);
        data.bottom = new FormAttachment(100, 0);
        this.composite.setLayoutData((Object)data);
    }

    protected CLabel createLabel(Control control, String text) {
        Assert.isNotNull((Object)control);
        Assert.isNotNull((Object)text);
        CLabel nameLabel = this.getWidgetFactory().createCLabel(this.composite, text);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(control, -5);
        data.top = new FormAttachment(control, 0, 0x1000000);
        data.width = SWTControlUtil.convertWidthInCharsToPixels((Control)nameLabel, (int)(text.length() + 2));
        nameLabel.setLayoutData((Object)data);
        return nameLabel;
    }

    protected Text createTextField(Control control, String label) {
        Text text = this.createText(control);
        this.createLabel((Control)text, label);
        return text;
    }

    protected Button createCheckbox(Control control, String label) {
        Button check = this.getWidgetFactory().createButton(this.composite, label, 32);
        FormData data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth());
        data.right = new FormAttachment(100, 0);
        data.top = control == null ? new FormAttachment(0, 4) : new FormAttachment(control, 4);
        check.setLayoutData((Object)data);
        check.setEnabled(false);
        return check;
    }

    protected Text createWrapTextField(Control control, String label) {
        Text text = this.createWrapText(control);
        this.createLabel((Control)text, label);
        return text;
    }

    protected Text createText(Control control) {
        Text text = this.getWidgetFactory().createText(this.composite, "", 524292);
        FormData data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth());
        data.right = new FormAttachment(100, 0);
        data.top = control == null ? new FormAttachment(0, 4) : new FormAttachment(control, 4);
        text.setLayoutData((Object)data);
        text.setEditable(false);
        return text;
    }

    protected Text createWrapText(Control control) {
        Text text = this.getWidgetFactory().createText(this.composite, "", 524352);
        FormData data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth());
        data.right = new FormAttachment(100, 0);
        data.top = control == null ? new FormAttachment(0, 4) : new FormAttachment(control, 4);
        data.width = 200;
        text.setLayoutData((Object)data);
        text.setEditable(false);
        return text;
    }

    public void refresh() {
        if (this.composite != null) {
            this.composite.layout();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.provider) {
            this.updateInput(this.provider);
            Display display = this.getPart().getSite().getShell().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    BaseTitledSection.this.refresh();
                }
            });
        }
    }

    protected abstract String getText();
}

