/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.view;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewRegistry;
import org.eclipse.net4j.util.container.Container;

public class CDOViewRegistryImpl
extends Container<CDOViewRegistry.Registration>
implements CDOViewRegistry {
    public static final CDOViewRegistryImpl INSTANCE = new CDOViewRegistryImpl();
    private final Map<Integer, CDOViewRegistry.Registration> ids = new HashMap<Integer, CDOViewRegistry.Registration>();
    private final Map<CDOView, CDOViewRegistry.Registration> views = new HashMap<CDOView, CDOViewRegistry.Registration>();
    private int lastID;

    public synchronized CDOViewRegistry.Registration[] getElements() {
        return this.ids.values().toArray(new CDOViewRegistry.Registration[this.ids.size()]);
    }

    @Override
    public synchronized int[] getIDs() {
        int[] result = new int[this.ids.size()];
        int i = 0;
        for (Integer id : this.ids.keySet()) {
            result[i++] = id;
        }
        return result;
    }

    @Override
    public synchronized CDOView[] getViews() {
        return this.views.keySet().toArray(new CDOView[this.views.size()]);
    }

    @Override
    public synchronized int getID(CDOView view) {
        CDOViewRegistry.Registration registration = this.views.get(view);
        if (registration != null) {
            return registration.getID();
        }
        return 0;
    }

    @Override
    public synchronized CDOView getView(int id) {
        CDOViewRegistry.Registration registration = this.ids.get(id);
        if (registration != null) {
            return registration.getView();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(CDOView view) {
        RegistrationImpl registration;
        CDOViewRegistryImpl cDOViewRegistryImpl = this;
        synchronized (cDOViewRegistryImpl) {
            if (this.views.containsKey(view)) {
                return;
            }
            int id = ++this.lastID;
            registration = new RegistrationImpl(id, view);
            this.ids.put(id, registration);
            this.views.put(view, registration);
        }
        this.fireElementAddedEvent(registration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deregister(CDOView view) {
        CDOViewRegistry.Registration registration;
        CDOViewRegistryImpl cDOViewRegistryImpl = this;
        synchronized (cDOViewRegistryImpl) {
            registration = this.views.remove(view);
            if (registration != null) {
                int id = registration.getID();
                this.ids.remove(id);
            }
        }
        this.fireElementRemovedEvent(registration);
    }

    private static final class RegistrationImpl
    implements CDOViewRegistry.Registration {
        private final int id;
        private final CDOView view;

        public RegistrationImpl(int id, CDOView view) {
            this.id = id;
            this.view = view;
        }

        @Override
        public int getID() {
            return this.id;
        }

        @Override
        public CDOView getView() {
            return this.view;
        }
    }
}

