/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.participants;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.commands.AbstractControlCommand;
import org.eclipse.papyrus.infra.services.controlmode.commands.CreateControlResource;
import org.eclipse.papyrus.infra.services.controlmode.commands.InitializeSashCommand;
import org.eclipse.papyrus.infra.services.controlmode.commands.RemoveControlResourceCommand;
import org.eclipse.papyrus.infra.services.controlmode.messages.Messages;
import org.eclipse.papyrus.infra.services.controlmode.participants.IControlCommandParticipant;
import org.eclipse.papyrus.infra.services.controlmode.participants.IUncontrolCommandParticipant;

public class SashControlParticipant
implements IControlCommandParticipant,
IUncontrolCommandParticipant {
    private static final String CLEAR_COMMAND = Messages.getString("SashControlParticipant.command.clear.label");
    private static final String DI_RESOURCE_ERROR = Messages.getString("SashControlParticipant.resource.di.error");
    private static final String RESOURCE_ERROR = Messages.getString("SashControlParticipant.resource.error");

    @Override
    public String getID() {
        return "org.eclipse.papyrus.infra.services.controlmode.participants.SashControlParticipant";
    }

    @Override
    public int getPriority() {
        return 80;
    }

    @Override
    public boolean provideControlCommand(ControlModeRequest request) {
        EObject objectBeingControl = request.getTargetObject();
        return objectBeingControl != null;
    }

    @Override
    public ICommand getPreControlCommand(ControlModeRequest request) {
        return new CreateControlResource(request, "di");
    }

    @Override
    public ICommand getPostControlCommand(ControlModeRequest request) {
        return new InitializeSashCommand(request);
    }

    @Override
    public boolean provideUnControlCommand(ControlModeRequest request) {
        EObject objectBeingControl = request.getTargetObject();
        return objectBeingControl != null;
    }

    @Override
    public ICommand getPreUncontrolCommand(ControlModeRequest request) {
        boolean result = this.setDiTargetRequest(request);
        if (result) {
            return this.getClearDiCommand(request);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected ICommand getClearDiCommand(ControlModeRequest request) {
        ModelSet modelSet = request.getModelSet();
        IFile affectedFiles = WorkspaceSynchronizer.getFile((Resource)modelSet.getAssociatedResource(request.getTargetObject(), "di", true));
        return new ClearDiCommand(Collections.singletonList(affectedFiles), request);
    }

    protected boolean setDiTargetRequest(ControlModeRequest request) {
        URI diURI = request.getNewURI().trimFileExtension().appendFileExtension("di");
        ModelSet modelSet = request.getModelSet();
        if (modelSet != null) {
            Resource diResource = null;
            try {
                diResource = modelSet.getResource(diURI, true);
            }
            catch (Exception e) {
                diResource = null;
            }
            if (diResource == null) {
                return false;
            }
            request.setTargetResource(diResource, "di");
            return true;
        }
        return false;
    }

    @Override
    public ICommand getPostUncontrolCommand(ControlModeRequest request) {
        return new RemoveControlResourceCommand(request, "di");
    }

    public class ClearDiCommand
    extends AbstractControlCommand {
        public ClearDiCommand(List affectedFiles, ControlModeRequest request) {
            super(CLEAR_COMMAND, affectedFiles, request);
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ModelSet modelSet = this.getRequest().getModelSet();
            if (modelSet == null) {
                return CommandResult.newErrorCommandResult((String)RESOURCE_ERROR);
            }
            Resource oldDiresource = modelSet.getAssociatedResource(this.getRequest().getTargetObject(), "di", true);
            if (oldDiresource == null) {
                return CommandResult.newErrorCommandResult((String)DI_RESOURCE_ERROR);
            }
            oldDiresource.getContents().clear();
            return CommandResult.newOKCommandResult();
        }
    }
}

