/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.references.actions;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ModelsReader;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServiceMultiException;
import org.eclipse.papyrus.infra.core.services.ServiceNotFoundException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationService;
import org.eclipse.papyrus.infra.services.openelement.service.OpenElementService;
import org.eclipse.papyrus.infra.services.openelement.service.impl.OpenElementServiceImpl;
import org.eclipse.papyrus.infra.ui.util.EditorUtils;
import org.eclipse.papyrus.views.references.Activator;
import org.eclipse.papyrus.views.references.Messages;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class GoToAction
extends BaseSelectionListenerAction {
    private static final String ID_VIEW_MODELEXPLORER = "org.eclipse.papyrus.views.modelexplorer.navigation.target";
    private static final ImageDescriptor GO_TO_IMAGE_DESCRIPTOR = Activator.imageDescriptorFromPlugin((String)"org.eclipse.search", (String)"icons/full/elcl16/search_goto.gif");
    private URI diResourceUri;
    private ServicesRegistry servicesRegistry;
    private ModelSet modelSet;

    public GoToAction() {
        super(Messages.ReferencesView_GoTo);
        this.setImageDescriptor(GO_TO_IMAGE_DESCRIPTOR);
    }

    private Collection<IEditorPart> getEditors() {
        IWorkbenchWindow[] windows;
        HashSet<IEditorPart> results = new HashSet<IEditorPart>();
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage[] pages;
            IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = pages = iWorkbenchWindow.getPages();
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorReference[] references;
                IWorkbenchPage iWorkbenchPage = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = references = iWorkbenchPage.getEditorReferences();
                int n5 = references.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference ref = iEditorReferenceArray[n6];
                    IEditorPart editor = ref.getEditor(true);
                    results.add(editor);
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return results;
    }

    private IEditorPart editorOnResource() {
        Collection<IEditorPart> editors = this.getEditors();
        for (IEditorPart editor : editors) {
            if (editor == null || !this.diResourceUri.equals(EditorUtils.getResourceURI((IEditorPart)editor))) continue;
            return editor;
        }
        return null;
    }

    private ServicesRegistry getUpdatedServiceRegistry() {
        IEditorPart editor;
        if (this.diResourceUri != null && (editor = this.editorOnResource()) != null) {
            return (ServicesRegistry)editor.getAdapter(ServicesRegistry.class);
        }
        return this.servicesRegistry;
    }

    private ServicesRegistry getServicesRegistry() {
        if (this.servicesRegistry == null) {
            ServicesRegistry registry = this.getUpdatedServiceRegistry();
            if (registry != null) {
                try {
                    registry.getService(OpenElementService.class);
                }
                catch (ServiceException e) {
                    registry.add(OpenElementService.class, 10, (IService)new OpenElementServiceImpl());
                }
                this.servicesRegistry = registry;
            } else {
                this.servicesRegistry = this.createServicesRegistry();
            }
        }
        return this.servicesRegistry;
    }

    private ServicesRegistry createServicesRegistry() {
        try {
            ServicesRegistry serviceRegistry = new ServicesRegistry();
            serviceRegistry.add(OpenElementService.class, 10, (IService)new OpenElementServiceImpl());
            serviceRegistry.startRegistry();
            return serviceRegistry;
        }
        catch (ServiceException e) {
            Activator.logError(e.getMessage());
            return null;
        }
    }

    public void run() {
        Object firstElement;
        IStructuredSelection structuredSelection = this.getStructuredSelection();
        if (structuredSelection instanceof ITreeSelection && (firstElement = ((ITreeSelection)structuredSelection).getFirstElement()) instanceof EStructuralFeature.Setting) {
            EObject source = ((EStructuralFeature.Setting)firstElement).getEObject();
            String nameEStructuralFeature = ((EStructuralFeature.Setting)firstElement).getEStructuralFeature().getName();
            if ("element".equals(nameEStructuralFeature)) {
                try {
                    this.diResourceUri = this.getDiResourceURI(source.eResource().getURI());
                    ModelSet modelSet = this.getModelSet(this.diResourceUri);
                    EObject eObject = modelSet.getEObject(EcoreUtil.getURI((EObject)source), true);
                    OpenElementService service = (OpenElementService)this.getServicesRegistry().getService(OpenElementService.class);
                    service.openElement(eObject);
                }
                catch (ServiceException e) {
                    Activator.logError(e.getMessage());
                }
                catch (PartInitException e) {
                    Activator.logError(e.getMessage());
                }
            } else {
                try {
                    NavigationService navigationService = (NavigationService)ServiceUtilsForEObject.getInstance().getService(NavigationService.class, (Object)source);
                    navigationService.navigate((Object)source, ID_VIEW_MODELEXPLORER);
                }
                catch (ServiceException e) {
                    Activator.logError(e.getMessage());
                }
            }
        }
    }

    private URI getDiResourceURI(URI uri) {
        URI fileURI = uri.trimFileExtension().trimFragment();
        fileURI = fileURI.appendFileExtension("di");
        return fileURI;
    }

    private ModelSet getModelSet(URI resourceUri) {
        if (this.modelSet == null) {
            try {
                this.modelSet = ServiceUtils.getInstance().getModelSet((Object)this.getServicesRegistry());
            }
            catch (ServiceException e) {
                try {
                    this.modelSet = GoToAction.openResource(resourceUri);
                    this.getServicesRegistry().add(ModelSet.class, 10, (Object)this.modelSet);
                    this.getServicesRegistry().startServicesByClassKeys(new Class[]{ModelSet.class});
                }
                catch (ModelMultiException modelMultiException) {
                    Activator.logError(String.valueOf(Messages.ReferencesView_FailedToOpenModelSet) + resourceUri);
                }
                catch (ServiceMultiException e1) {
                    Activator.logError(e1.getMessage());
                }
                catch (ServiceNotFoundException e1) {
                    Activator.logError(e1.getMessage());
                }
            }
        }
        return this.modelSet;
    }

    private static final ModelSet openResource(URI resourceURI) throws ModelMultiException {
        if (resourceURI != null) {
            ModelSet modelSet = new ModelSet();
            ModelsReader reader = new ModelsReader();
            reader.readModel(modelSet);
            modelSet.loadModels(resourceURI);
            return modelSet;
        }
        return null;
    }
}

