/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.internal;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.jubula.client.internal.BaseConnection;
import org.eclipse.jubula.client.internal.exceptions.ConnectionException;
import org.eclipse.jubula.communication.internal.Communicator;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutAgentConnection
extends BaseConnection {
    public static final Object CONNECT_TO_AGENT_JOB_FAMILY_ID = new Object();
    private static Logger log = LoggerFactory.getLogger(AutAgentConnection.class);
    private static AutAgentConnection instance = null;

    private AutAgentConnection(InetAddress inetAddress, int port) {
        Communicator communicator = new Communicator(inetAddress, port, this.getClass().getClassLoader());
        communicator.setIsServerSocketClosable(false);
        this.setCommunicator(communicator);
    }

    public static synchronized void createInstance(String serverName, String port) throws ConnectionException {
        try {
            InetAddress inetAddress = InetAddress.getByName(serverName);
            instance = new AutAgentConnection(inetAddress, new Integer(port));
        }
        catch (UnknownHostException uhe) {
            log.info(uhe.getLocalizedMessage(), (Throwable)uhe);
            throw new ConnectionException(uhe.getMessage(), MessageIDs.E_UNKNOWN_HOST);
        }
    }

    public static synchronized AutAgentConnection getInstance() throws ConnectionException {
        if (instance == null) {
            String message = "ServerConnection is not initialized";
            throw new ConnectionException(message, MessageIDs.E_NO_SERVER_CONNECTION_INIT);
        }
        return instance;
    }
}

