/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.requests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequestFactory;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;

public class CreateUnspecifiedTypeConnectionRequest
extends CreateConnectionRequest {
    private List relationshipTypes;
    private Map requests = new HashMap();
    private boolean useModelingAssistantService;
    private boolean directionReversed = false;
    private PreferencesHint preferencesHint;

    public CreateUnspecifiedTypeConnectionRequest(List relationshipTypes, boolean useModelingAssistantService, PreferencesHint preferencesHint) {
        this.useModelingAssistantService = useModelingAssistantService;
        this.relationshipTypes = relationshipTypes;
        this.preferencesHint = preferencesHint;
        this.createRequests();
    }

    private void createRequests() {
        for (IElementType elementType : this.relationshipTypes) {
            CreateConnectionViewRequest request = CreateViewRequestFactory.getCreateConnectionRequest(elementType, this.getPreferencesHint());
            request.setType(this.getType());
            this.requests.put(elementType, request);
        }
    }

    public CreateRequest getRequestForType(IElementType relationshipType) {
        if (this.requests != null) {
            return (CreateConnectionRequest)this.requests.get(relationshipType);
        }
        return null;
    }

    public void addRequest(IElementType relationshipType, Request request) {
        if (this.requests != null) {
            this.requests.put(relationshipType, request);
        }
    }

    public List getAllRequests() {
        if (this.requests != null) {
            return new ArrayList(this.requests.values());
        }
        return Collections.EMPTY_LIST;
    }

    public List getElementTypes() {
        return this.relationshipTypes;
    }

    public void setSourceEditPart(EditPart part) {
        if (this.requests != null) {
            for (CreateConnectionRequest request : this.requests.values()) {
                request.setSourceEditPart(part);
            }
        }
        super.setSourceEditPart(part);
    }

    public void setTargetEditPart(EditPart part) {
        if (this.requests != null) {
            for (CreateConnectionRequest request : this.requests.values()) {
                request.setTargetEditPart(part);
            }
        }
        super.setTargetEditPart(part);
    }

    public void setLocation(Point location) {
        if (this.requests != null) {
            for (CreateConnectionRequest request : this.requests.values()) {
                request.setLocation(location);
            }
        }
        super.setLocation(location);
    }

    public void setType(Object type) {
        if (this.requests != null) {
            for (CreateConnectionRequest request : this.requests.values()) {
                request.setType(type);
            }
        }
        super.setType(type);
    }

    public boolean isDirectionReversed() {
        return this.directionReversed;
    }

    public void setDirectionReversed(boolean directionReversed) {
        this.directionReversed = directionReversed;
    }

    public boolean useModelingAssistantService() {
        return this.useModelingAssistantService;
    }

    protected PreferencesHint getPreferencesHint() {
        return this.preferencesHint;
    }
}

