/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProjectHelper {
    public static void addNatures(IProjectDescription description, List<String> natures, IProgressMonitor monitor) {
        HashSet<String> allNatures = new HashSet<String>();
        allNatures.addAll(natures);
        allNatures.addAll(Arrays.asList(description.getNatureIds()));
        description.setNatureIds(allNatures.toArray(new String[allNatures.size()]));
    }

    private static int indexOf(List<ICommand> buildSpecs, String builder) {
        for (ICommand cmd : buildSpecs) {
            if (!builder.equals(cmd.getBuilderName())) continue;
            return buildSpecs.indexOf(cmd);
        }
        return -1;
    }

    public static void addBuilders(IProjectDescription description, List<String> builders, IProgressMonitor monitor) {
        ArrayList<ICommand> buildSpecs = new ArrayList<ICommand>();
        buildSpecs.addAll(Arrays.asList(description.getBuildSpec()));
        for (String newBuilder : builders) {
            int index = ProjectHelper.indexOf(buildSpecs, newBuilder);
            if (index >= 0) continue;
            ICommand newCommand = description.newCommand();
            newCommand.setBuilderName(newBuilder);
            buildSpecs.add(newCommand);
            index = buildSpecs.size() - 1;
        }
        int index = ProjectHelper.indexOf(buildSpecs, "org.eclipse.egf.pattern.ui.PatternBuilder");
        if (index > 0) {
            Collections.swap(buildSpecs, index, 0);
        }
        description.setBuildSpec(buildSpecs.toArray(new ICommand[buildSpecs.size()]));
    }

    private ProjectHelper() {
    }
}

