/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.dataprovider;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderFactory;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public class DataProviderManager {
    private static @Nullable DataProviderManager INSTANCE;
    private static final String EXTENSION_POINT_ID = "org.eclipse.tracecompass.tmf.core.dataprovider";
    private static final String ELEMENT_NAME_PROVIDER = "dataProviderFactory";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_ID = "id";
    private Map<String, IDataProviderFactory> fDataProviderFactories = new HashMap<String, IDataProviderFactory>();
    private final Multimap<ITmfTrace, ITmfTreeDataProvider<? extends ITmfTreeDataModel>> fInstances = LinkedHashMultimap.create();

    public static synchronized DataProviderManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DataProviderManager();
        }
        return INSTANCE;
    }

    public static synchronized void dispose() {
        DataProviderManager manager = INSTANCE;
        if (manager != null) {
            TmfSignalManager.deregister(manager);
            for (IDataProviderFactory factory : manager.fDataProviderFactories.values()) {
                TmfSignalManager.deregister(factory);
            }
            manager.fDataProviderFactories.clear();
            manager.fInstances.clear();
        }
        INSTANCE = null;
    }

    private DataProviderManager() {
        this.loadDataProviders();
        TmfSignalManager.register(this);
    }

    private void loadDataProviders() {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement cElement = iConfigurationElementArray[n2];
            if (cElement != null && cElement.getName().equals(ELEMENT_NAME_PROVIDER)) {
                try {
                    Object extension = cElement.createExecutableExtension(ATTR_CLASS);
                    this.fDataProviderFactories.put(cElement.getAttribute(ATTR_ID), (IDataProviderFactory)extension);
                }
                catch (CoreException e) {
                    Activator.logError("Unable to load extensions", e);
                }
            }
            ++n2;
        }
    }

    public synchronized <T extends ITmfTreeDataProvider<? extends ITmfTreeDataModel>> @Nullable T getDataProvider(@NonNull ITmfTrace trace, String id, Class<T> dataProviderClass) {
        for (ITmfTreeDataProvider dataProvider : this.fInstances.get((Object)trace)) {
            if (!id.equals(dataProvider.getId()) || !dataProviderClass.isAssignableFrom(dataProvider.getClass())) continue;
            return (T)((ITmfTreeDataProvider)dataProviderClass.cast(dataProvider));
        }
        String[] ids = id.split(":");
        for (ITmfTrace opened : TmfTraceManager.getInstance().getOpenedTraces()) {
            if (!TmfTraceManager.getTraceSetWithExperiment(opened).contains(trace)) continue;
            IDataProviderFactory providerFactory = this.fDataProviderFactories.get(ids[0]);
            if (providerFactory != null) {
                ITmfTreeDataProvider<? extends ITmfTreeDataModel> dataProvider;
                ITmfTreeDataProvider<? extends ITmfTreeDataModel> iTmfTreeDataProvider = dataProvider = ids.length > 1 ? providerFactory.createProvider(trace, String.valueOf(ids[1])) : providerFactory.createProvider(trace);
                if (dataProvider != null && id.equals(dataProvider.getId()) && dataProviderClass.isAssignableFrom(dataProvider.getClass())) {
                    this.fInstances.put((Object)trace, dataProvider);
                    return (T)((ITmfTreeDataProvider)dataProviderClass.cast(dataProvider));
                }
            }
            return null;
        }
        return null;
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        new Thread(() -> {
            DataProviderManager dataProviderManager = this;
            synchronized (dataProviderManager) {
                for (ITmfTrace trace : TmfTraceManager.getTraceSetWithExperiment(signal.getTrace())) {
                    this.fInstances.removeAll((Object)trace).forEach(ITmfTreeDataProvider::dispose);
                }
            }
        }).start();
    }

    public List<IDataProviderDescriptor> getAvailableProviders(@Nullable ITmfTrace trace) {
        if (trace == null) {
            return Collections.emptyList();
        }
        ArrayList<IDataProviderDescriptor> list = new ArrayList<IDataProviderDescriptor>();
        for (IDataProviderFactory factory : this.fDataProviderFactories.values()) {
            Collection<IDataProviderDescriptor> descriptors = factory.getDescriptors(trace);
            if (descriptors.isEmpty()) continue;
            list.addAll(descriptors);
        }
        return list;
    }

    public <T extends ITmfTreeDataProvider<? extends ITmfTreeDataModel>> boolean removeDataProvider(ITmfTrace trace, T provider) {
        return this.fInstances.remove((Object)trace, provider);
    }
}

