/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.utils;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.utils.IExecutableOperation;
import org.eclipse.dltk.utils.IExecutionContextManager;

public class ExecutionContexts {
    private static IExecutionContextManager fManager;
    private static IExecutionContextManager fDefaultManager;

    static {
        fDefaultManager = new IExecutionContextManager(){

            @Override
            public void executeInBackground(IExecutableOperation operation) {
                operation.execute((IProgressMonitor)new NullProgressMonitor());
            }

            @Override
            public boolean isRunningInUIThread() {
                return false;
            }
        };
    }

    public static synchronized IExecutionContextManager getManager() {
        if (fManager != null) {
            return fManager;
        }
        return fDefaultManager;
    }

    public static synchronized void setManager(IExecutionContextManager manager) {
        fManager = manager;
    }
}

