/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragmentTimestamp;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.internal.environment.EFSFileHandle;
import org.eclipse.dltk.internal.core.ExternalProjectFragmentInfo;
import org.eclipse.dltk.internal.core.ExternalScriptFolder;
import org.eclipse.dltk.internal.core.ExternalScriptFolderInfo;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.OpenableElementInfo;
import org.eclipse.dltk.internal.core.ProjectFragment;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.internal.core.util.Util;

public class ExternalProjectFragment
extends ProjectFragment
implements IProjectFragmentTimestamp {
    public static final ArrayList EMPTY_LIST = new ArrayList();
    protected final IPath fPath;
    protected final boolean fReadOnly;
    protected final boolean fOnlyScriptResources;

    protected ExternalProjectFragment(IPath path, ScriptProject project, boolean isReadOnly, boolean onlyScriptResources) {
        super(null, project);
        this.fPath = path;
        this.fReadOnly = isReadOnly;
        this.fOnlyScriptResources = onlyScriptResources;
    }

    @Override
    protected boolean computeChildren(OpenableElementInfo info, Map newElements) throws ModelException {
        ArrayList vChildren = new ArrayList(5);
        ArrayList vForeign = new ArrayList(5);
        char[][] inclusionPatterns = this.fullInclusionPatternChars();
        char[][] exclusionPatterns = this.fullExclusionPatternChars();
        HashSet realPaths = new HashSet();
        this.computeFolderChildren(this.fPath, !Util.isExcluded(this.fPath, inclusionPatterns, exclusionPatterns, true), vChildren, vForeign, newElements, inclusionPatterns, exclusionPatterns, realPaths);
        IModelElement[] children = new IModelElement[vChildren.size()];
        vChildren.toArray(children);
        info.setChildren(children);
        return true;
    }

    protected void computeFolderChildren(IPath path, boolean isIncluded, ArrayList vChildren, ArrayList vForeign, Map newElements, char[][] inclusionPatterns, char[][] exclusionPatterns, Set realPaths) throws ModelException {
        IFileHandle file;
        String canonicalPath;
        IEnvironment environment = EnvironmentPathUtils.getPathEnvironment(path);
        if (environment != null && !realPaths.add(canonicalPath = (file = environment.getFile(EnvironmentPathUtils.getLocalPath(path))).getCanonicalPath())) {
            return;
        }
        IPath lpath = path.setDevice(null).removeFirstSegments(this.fPath.segmentCount());
        ExternalScriptFolder fldr = (ExternalScriptFolder)this.getScriptFolder(lpath);
        boolean valid = Util.isValidSourcePackageName(this, path);
        if ((lpath.segmentCount() == 0 || valid) && isIncluded) {
            vChildren.add(fldr);
        } else {
            if (this.fOnlyScriptResources) {
                return;
            }
            if (!valid) {
                return;
            }
        }
        ArrayList<IPath> scriptElements = new ArrayList<IPath>();
        ArrayList<IPath> nonScriptElements = new ArrayList<IPath>();
        try {
            IFileHandle file2 = EnvironmentPathUtils.getFile(path);
            IFileHandle[] members = file2.getChildren();
            if (members != null) {
                int i = 0;
                int max = members.length;
                while (i < max) {
                    IFileHandle memberFile = members[i];
                    IPath memberPath = memberFile.getFullPath();
                    if (memberFile.isDirectory()) {
                        boolean isMemberIncluded = !Util.isExcluded(memberPath, inclusionPatterns, exclusionPatterns, true);
                        this.computeFolderChildren(memberPath, isMemberIncluded, vChildren, vForeign, newElements, inclusionPatterns, exclusionPatterns, realPaths);
                    } else if (Util.isValidSourceModule((IModelElement)this, memberPath)) {
                        scriptElements.add(memberPath);
                    } else if (!this.fOnlyScriptResources || valid) {
                        nonScriptElements.add(memberPath);
                    }
                    ++i;
                }
            }
            ExternalScriptFolderInfo fragInfo = new ExternalScriptFolderInfo();
            fldr.computeChildren(fragInfo, scriptElements);
            fldr.computeForeignResources(fragInfo, nonScriptElements);
            newElements.put(fldr, fragInfo);
        }
        catch (IllegalArgumentException e) {
            throw new ModelException(e, 969);
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }

    @Override
    public void getHandleMemento(StringBuffer buff) {
        ((ModelElement)this.getParent()).getHandleMemento(buff);
        buff.append(this.getHandleMementoDelimiter());
        this.escapeMementoName(buff, this.getElementName());
    }

    @Override
    public IScriptFolder getScriptFolder(IPath path) {
        block4: {
            try {
                String portablePath = path.toPortableString();
                IModelElement[] children = this.getChildren();
                int i = 0;
                while (i < children.length) {
                    IModelElement child = children[i];
                    if (child.getElementType() == 4 && ((IScriptFolder)child).getElementName().equals(portablePath)) {
                        return (IScriptFolder)child;
                    }
                    ++i;
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return new ExternalScriptFolder(this, path);
    }

    @Override
    public IScriptFolder getScriptFolder(String path) {
        return this.getScriptFolder((IPath)new Path(path));
    }

    @Override
    public boolean isReadOnly() {
        return this.fReadOnly;
    }

    @Override
    protected Object createElementInfo() {
        return new ExternalProjectFragmentInfo();
    }

    @Override
    public boolean isArchive() {
        return false;
    }

    @Override
    public boolean isExternal() {
        return true;
    }

    @Override
    public IResource getUnderlyingResource() throws ModelException {
        return null;
    }

    @Override
    public int hashCode() {
        return this.fPath.hashCode();
    }

    @Override
    public IPath getPath() {
        return this.fPath;
    }

    @Override
    public IResource getResource() {
        return null;
    }

    @Override
    protected boolean resourceExists() {
        if (this.fPath.toString().startsWith("#special#builtin#")) {
            return true;
        }
        IFileHandle file = EnvironmentPathUtils.getFile(this.fPath);
        return file.exists() && file.isDirectory();
    }

    @Override
    protected void toStringAncestors(StringBuffer buffer) {
    }

    @Override
    public int getKind() {
        return 1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ExternalProjectFragment) {
            ExternalProjectFragment other = (ExternalProjectFragment)o;
            if (this.fPath.equals((Object)other.fPath)) {
                IEnvironment environmento;
                IEnvironment environment = EnvironmentManager.getEnvironment(this);
                return environment == null || environment.equals(environmento = EnvironmentManager.getEnvironment(other));
            }
        }
        return false;
    }

    @Override
    public String getElementName() {
        IEnvironment env = EnvironmentManager.getEnvironment(this);
        if (env == null) {
            env = EnvironmentPathUtils.getPathEnvironment(this.fPath);
        }
        String pathString = EnvironmentPathUtils.getLocalPathString(this.fPath);
        if (env != null && pathString != null) {
            return pathString.replace(env.getSeparatorChar(), '>');
        }
        return this.fPath.lastSegment();
    }

    @Override
    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '<': {
                String pkgName;
                if (memento.hasMoreTokens()) {
                    pkgName = memento.nextToken();
                    char firstChar = pkgName.charAt(0);
                    if (firstChar == '{' || firstChar == '!') {
                        token = pkgName;
                        pkgName = "";
                    } else {
                        token = null;
                    }
                } else {
                    pkgName = "";
                    token = null;
                }
                ModelElement pkg = (ModelElement)((Object)this.getScriptFolder(pkgName));
                if (token == null) {
                    return pkg.getHandleFromMemento(memento, owner);
                }
                return pkg.getHandleFromMemento(token, memento, owner);
            }
        }
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '/';
    }

    @Override
    public IBuildpathEntry getBuildpathEntry() throws ModelException {
        IBuildpathEntry rawEntry = super.getRawBuildpathEntry();
        if (rawEntry != null && rawEntry.getEntryKind() == 5) {
            IBuildpathContainer container = DLTKCore.getBuildpathContainer(rawEntry.getPath(), this.getScriptProject());
            IBuildpathEntry[] entrys = container.getBuildpathEntries();
            int i = 0;
            while (i < entrys.length) {
                if (entrys[i].getPath().equals((Object)this.getPath())) {
                    return entrys[i];
                }
                ++i;
            }
        }
        return rawEntry;
    }

    @Override
    public long getTimeStamp() {
        block7: {
            IFileHandle file;
            long stamp;
            IEnvironment environment;
            block6: {
                environment = EnvironmentManager.getEnvironment(this);
                stamp = 0L;
                file = environment.getFile(this.getPath());
                if (file != null && file.exists()) {
                    long lmodif = 0L;
                    lmodif = file instanceof EFSFileHandle ? ((EFSFileHandle)file).lastModified() : file.lastModified();
                    stamp = lmodif;
                    break block6;
                }
                return 0L;
            }
            try {
                IModelElement[] children = this.getChildren();
                int i = 0;
                while (i < children.length) {
                    IScriptFolder folder;
                    IPath path;
                    if (children[i].getElementType() == 4 && (file = environment.getFile(path = (folder = (IScriptFolder)children[i]).getPath())) != null && file.exists()) {
                        stamp = stamp * 13L + file.lastModified();
                    }
                    ++i;
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block7;
                e.printStackTrace();
            }
        }
        return 0L;
    }
}

