/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.ui.script.launcher;

import org.eclipse.birt.report.debug.internal.core.vm.ReportVMClient;
import org.eclipse.birt.report.debug.internal.script.model.ScriptDebugTarget;
import org.eclipse.birt.report.debug.internal.ui.script.launcher.ReportLaunchHelper;
import org.eclipse.birt.report.debug.internal.ui.script.launcher.ReportOSGiLaunchDelegate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

class ReportDebuggerVMRunner
implements IVMRunner {
    private ReportOSGiLaunchDelegate config;
    private IVMRunner delegate;
    private boolean runScript;

    ReportDebuggerVMRunner(IVMRunner delegate, boolean runScript, ReportOSGiLaunchDelegate config) {
        this.delegate = delegate;
        this.runScript = runScript;
        this.config = config;
    }

    public void run(VMRunnerConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.delegate.run(configuration, launch, monitor);
        IProcess[] ps = launch.getProcesses();
        if (ps != null && ps.length > 0) {
            if (this.runScript) {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                subMonitor.beginTask("Launching VM...", 1);
                ReportVMClient vm = new ReportVMClient();
                ScriptDebugTarget target = new ScriptDebugTarget(launch, vm, null, ps[0], this.config.helper.listenPort, this.config.helper.tempFolder);
                target.setFileName(this.config.helper.fileName);
                subMonitor.worked(1);
                subMonitor.done();
            }
            ReportLaunchHelper.handleProcessTermination(launch, ps[0], this.config.helper.fileName, this.config.helper.tempFolder);
        }
    }
}

