/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.filter;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterAndNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterCompareNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterContainsNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterEqualsNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterMatchesNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterOrNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterTraceTypeNode;

public class FilterTreeLabelProvider
implements ILabelProvider {
    private static final String EMPTY_STRING = "";
    private static final String QUOTE = "\"";
    private static final String SPACE_QUOTE = " \"";
    private static final String NOT = "NOT ";

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        StringBuilder label = new StringBuilder();
        if (element instanceof TmfFilterNode) {
            TmfFilterNode node = (TmfFilterNode)element;
            label.append(node.getNodeName()).append(' ').append(node.getFilterName() != null && !node.getFilterName().isEmpty() ? node.getFilterName() : Messages.FilterTreeLabelProvider_FilterNameHint);
        } else if (element instanceof TmfFilterTraceTypeNode) {
            TmfFilterTraceTypeNode node = (TmfFilterTraceTypeNode)element;
            label.append("WITH ").append(node.getNodeName()).append(' ').append(node.getName() != null ? node.getName() : Messages.FilterTreeLabelProvider_TraceTypeHint);
        } else if (element instanceof TmfFilterAndNode) {
            TmfFilterAndNode node = (TmfFilterAndNode)element;
            label.append(node.isNot() ? NOT : EMPTY_STRING).append(node.getNodeName());
        } else if (element instanceof TmfFilterOrNode) {
            TmfFilterOrNode node = (TmfFilterOrNode)element;
            label.append(node.isNot() ? NOT : EMPTY_STRING).append(node.getNodeName());
        } else if (element instanceof TmfFilterContainsNode) {
            TmfFilterContainsNode node = (TmfFilterContainsNode)element;
            label.append(node.isNot() ? NOT : EMPTY_STRING).append(node.getEventAspect() != null ? node.getAspectLabel(false) : Messages.FilterTreeLabelProvider_AspectHint).append(' ').append(node.getNodeName()).append(node.getValue() != null ? SPACE_QUOTE + node.getValue() + QUOTE : EMPTY_STRING);
        } else if (element instanceof TmfFilterEqualsNode) {
            TmfFilterEqualsNode node = (TmfFilterEqualsNode)element;
            label.append(node.isNot() ? NOT : EMPTY_STRING).append(node.getEventAspect() != null ? node.getAspectLabel(false) : Messages.FilterTreeLabelProvider_AspectHint).append(' ').append(node.getNodeName()).append(node.getValue() != null ? SPACE_QUOTE + node.getValue() + QUOTE : EMPTY_STRING);
        } else if (element instanceof TmfFilterMatchesNode) {
            TmfFilterMatchesNode node = (TmfFilterMatchesNode)element;
            label.append(node.isNot() ? NOT : EMPTY_STRING).append(node.getEventAspect() != null ? node.getAspectLabel(false) : Messages.FilterTreeLabelProvider_AspectHint).append(' ').append(node.getNodeName()).append(node.getRegex() != null ? SPACE_QUOTE + node.getRegex() + QUOTE : EMPTY_STRING);
        } else if (element instanceof TmfFilterCompareNode) {
            TmfFilterCompareNode node = (TmfFilterCompareNode)element;
            label.append(node.isNot() ? NOT : EMPTY_STRING).append(node.getEventAspect() != null ? node.getAspectLabel(false) : Messages.FilterTreeLabelProvider_AspectHint).append(node.getResult() < 0 ? " <" : (node.getResult() > 0 ? " >" : " =")).append(node.getType() == TmfFilterCompareNode.Type.ALPHA ? SPACE_QUOTE : (node.getType() == TmfFilterCompareNode.Type.TIMESTAMP ? " [" : Character.valueOf(' '))).append(node.hasValidValue() ? node.getValue() : Messages.FilterTreeLabelProvider_ValueHint).append(node.getType() == TmfFilterCompareNode.Type.ALPHA ? Character.valueOf('\"') : (node.getType() == TmfFilterCompareNode.Type.TIMESTAMP ? Character.valueOf(']') : EMPTY_STRING));
        }
        return label.toString();
    }
}

