/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.ui.action;

import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.scout.sdk.s2e.nls.NlsCore;
import org.eclipse.scout.sdk.s2e.nls.internal.model.NlsReferenceProvider;
import org.eclipse.scout.sdk.s2e.nls.internal.search.NlsFindKeysJob;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.editor.NlsTable;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.editor.NlsTableModel;
import org.eclipse.scout.sdk.s2e.nls.project.INlsProject;

public class UpdateReferenceCountAction
extends Action {
    private final INlsProject m_project;
    private final NlsTable m_table;
    private final NlsTableModel m_tableModel;
    private NlsFindKeysJob m_job;

    public UpdateReferenceCountAction(INlsProject project, NlsTable table, NlsTableModel model) {
        this.m_project = project;
        this.m_table = table;
        this.m_tableModel = model;
        this.setEnabled(project != null);
        this.setText("Show NLS Entry usage");
        this.setImageDescriptor(NlsCore.getImageDescriptor("find_obj"));
    }

    public void run() {
        this.m_job = new NlsFindKeysJob(this.m_project, this.getText());
        this.m_job.addJobChangeListener((IJobChangeListener)new P_JobListener());
        this.m_job.schedule();
    }

    private void handleBeginSearch() {
        this.m_table.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                UpdateReferenceCountAction.this.setEnabled(false);
            }
        });
    }

    private void handleEndSearch() {
        this.m_table.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (UpdateReferenceCountAction.this.m_table.isDisposed()) {
                    return;
                }
                UpdateReferenceCountAction.this.setEnabled(true);
                UpdateReferenceCountAction.this.m_tableModel.setReferenceProvider(new NlsReferenceProvider(UpdateReferenceCountAction.this.m_job.getAllMatches()));
                UpdateReferenceCountAction.this.m_table.refreshAll(false);
            }
        });
    }

    private class P_JobListener
    extends JobChangeAdapter {
        private P_JobListener() {
        }

        public void scheduled(IJobChangeEvent event) {
            UpdateReferenceCountAction.this.handleBeginSearch();
        }

        public void done(IJobChangeEvent event) {
            UpdateReferenceCountAction.this.handleEndSearch();
        }
    }
}

