/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.signal.confirmation;

import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.net4j.util.confirmation.Confirmation;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfirmationPrompt {
    private final String subject;
    private final String message;
    private final Set<Confirmation> acceptableResponses;
    private final Confirmation suggestedResponse;

    public ConfirmationPrompt(String subject, String message, Confirmation suggestedResponse, Confirmation acceptableResponse, Confirmation ... more) {
        this(subject, message, suggestedResponse, EnumSet.of(acceptableResponse, more));
    }

    public ConfirmationPrompt(String subject, String message, Confirmation suggestedResponse, Collection<Confirmation> acceptableResponses) {
        this.subject = subject;
        this.message = message;
        this.acceptableResponses = EnumSet.copyOf(acceptableResponses);
        this.suggestedResponse = suggestedResponse;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getMessage() {
        return this.message;
    }

    public Set<Confirmation> getAcceptableResponses() {
        return this.acceptableResponses;
    }

    public Confirmation getSuggestedResponse() {
        return this.suggestedResponse;
    }

    public void write(ExtendedDataOutput out) throws IOException {
        out.writeString(this.subject);
        out.writeString(this.message);
        out.writeEnum((Enum)this.suggestedResponse);
        out.writeInt(this.acceptableResponses.size());
        for (Confirmation acceptable : this.acceptableResponses) {
            out.writeEnum((Enum)acceptable);
        }
    }

    public static ConfirmationPrompt read(ExtendedDataInput in) throws IOException {
        String subject = in.readString();
        String message = in.readString();
        Confirmation suggestion = (Confirmation)in.readEnum(Confirmation.class);
        EnumSet<Confirmation> acceptable = EnumSet.noneOf(Confirmation.class);
        int count = in.readInt();
        int i = 0;
        while (i < count) {
            acceptable.add((Confirmation)in.readEnum(Confirmation.class));
            ++i;
        }
        return new ConfirmationPrompt(subject, message, suggestion, acceptable);
    }
}

