/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.edit;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.Messages;
import org.eclipse.corrosion.RustManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class RLSStreamConnectionProvider
implements StreamConnectionProvider {
    private static boolean hasCancelledSetup = false;
    private Process process;

    public void start() throws IOException {
        String rls = RustManager.getRLS();
        if (rls.isEmpty() || !RustManager.setSystemProperties() || !CorrosionPlugin.validateCommandVersion(rls, RustManager.RLS_VERSION_FORMAT_PATTERN)) {
            RLSStreamConnectionProvider.showSetupRustNotification();
            return;
        }
        this.process = CorrosionPlugin.getProcessForCommand(rls);
    }

    private static void showSetupRustNotification() {
        Display.getDefault().asyncExec(() -> {
            if (hasCancelledSetup) {
                return;
            }
            RLSStreamConnectionProvider.setHasCancelledSetup(true);
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            int dialogResponse = MessageDialog.open((int)5, (Shell)shell, (String)Messages.RLSStreamConnectionProvider_rustSupportNotFound, (String)Messages.RLSStreamConnectionProvider_requirementsNotFound, (int)0, (String[])new String[]{Messages.RLSStreamConnectionProvider_OpenPreferences, IDialogConstants.CANCEL_LABEL});
            if (dialogResponse == 0) {
                PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.eclipse.corrosion.preferencePage", (String[])new String[]{"org.eclipse.corrosion.preferencePage"}, null);
                preferenceDialog.setBlockOnOpen(true);
                preferenceDialog.open();
                RLSStreamConnectionProvider.setHasCancelledSetup(false);
            }
        });
    }

    private static synchronized void setHasCancelledSetup(Boolean newValue) {
        hasCancelledSetup = newValue;
    }

    private static Map<String, Object> getDefaultInitializationOptions() {
        HashMap<String, String> initializationSettings = new HashMap<String, String>();
        initializationSettings.put("clippy_preference", "on");
        return Collections.singletonMap("settings", Collections.singletonMap("rust", initializationSettings));
    }

    public Object getInitializationOptions(URI rootUri) {
        String settingsPath = RustManager.getRlsConfigurationPath();
        File settingsFile = new File(settingsPath);
        Gson gson = new Gson();
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try (JsonReader reader = new JsonReader((Reader)new FileReader(settingsFile));){
                return gson.fromJson(reader, HashMap.class);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            CorrosionPlugin.getDefault().getLog().log((IStatus)new Status(1, CorrosionPlugin.getDefault().getBundle().getSymbolicName(), MessageFormat.format(Messages.RLSStreamConnectionProvider_rlsConfigurationNotFound, settingsPath)));
        }
        catch (Throwable e) {
            CorrosionPlugin.getDefault().getLog().log((IStatus)new Status(4, CorrosionPlugin.getDefault().getBundle().getSymbolicName(), MessageFormat.format(Messages.RLSStreamConnectionProvider_rlsConfigurationError, settingsPath, e)));
        }
        return RLSStreamConnectionProvider.getDefaultInitializationOptions();
    }

    public InputStream getInputStream() {
        return this.process == null ? null : this.process.getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.process == null ? null : this.process.getOutputStream();
    }

    public void stop() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public InputStream getErrorStream() {
        return this.process == null ? null : this.process.getErrorStream();
    }
}

